/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

public final class BitsInt {
    private static final int IntLen = 32;

    private BitsInt() {
    }

    public static final int unpack(int bits, int start, int finish) {
        BitsInt.check(start, finish);
        if (finish == 0) {
            return 0;
        }
        return bits << 32 - finish >>> 32 - finish + start;
    }

    public static final int pack(int bits, int value, int start, int finish) {
        BitsInt.check(start, finish);
        bits = BitsInt.clear$(bits, start, finish);
        int mask = BitsInt.mask(start, finish);
        return bits |= value << start & mask;
    }

    public static final int unpack(String str2, int startChar, int finishChar) {
        String s2 = str2.substring(startChar, finishChar);
        return Integer.parseInt(s2, 16);
    }

    public static final int set(int bits, int bitIndex) {
        BitsInt.check(bitIndex);
        return BitsInt.set$(bits, bitIndex);
    }

    public static final int set(int bits, int start, int finish) {
        BitsInt.check(start, finish);
        return BitsInt.set$(bits, start, finish);
    }

    public static final boolean test(int bits, boolean isSet, int bitIndex) {
        BitsInt.check(bitIndex);
        return BitsInt.test$(bits, isSet, bitIndex);
    }

    public static final boolean isSet(int bits, int bitIndex) {
        BitsInt.check(bitIndex);
        return BitsInt.test$(bits, true, bitIndex);
    }

    public static final boolean test(int bits, int value, int start, int finish) {
        BitsInt.check(start, finish);
        return BitsInt.test$(bits, value, start, finish);
    }

    public static final int access(int bits, int start, int finish) {
        BitsInt.check(start, finish);
        return BitsInt.access$(bits, start, finish);
    }

    public static final int clear(int bits, int bitIndex) {
        BitsInt.check(bitIndex);
        return BitsInt.clear$(bits, bitIndex);
    }

    public static final int clear(int bits, int start, int finish) {
        BitsInt.check(start, finish);
        return BitsInt.clear$(bits, start, finish);
    }

    public static final int mask(int start, int finish) {
        BitsInt.check(start, finish);
        return BitsInt.mask$(start, finish);
    }

    public static final int maskZero(int start, int finish) {
        BitsInt.check(start, finish);
        return BitsInt.maskZero$(start, finish);
    }

    private static final int clear$(int bits, int bitIndex) {
        int mask = BitsInt.maskZero$(bitIndex);
        return bits &= mask;
    }

    private static final int clear$(int bits, int start, int finish) {
        int mask = BitsInt.maskZero$(start, finish);
        return bits &= mask;
    }

    private static final int set$(int bits, int bitIndex) {
        int mask = BitsInt.mask$(bitIndex);
        return bits | mask;
    }

    private static final int set$(int bits, int start, int finish) {
        int mask = BitsInt.mask$(start, finish);
        return bits | mask;
    }

    private static final boolean test$(int bits, boolean isSet, int bitIndex) {
        return isSet == BitsInt.access$(bits, bitIndex);
    }

    private static final boolean test$(int bits, int value, int start, int finish) {
        int v = BitsInt.access$(bits, start, finish);
        return v == value;
    }

    private static final boolean access$(int bits, int bitIndex) {
        int mask = BitsInt.mask$(bitIndex);
        return (long)(bits & mask) != 0L;
    }

    private static final int access$(int bits, int start, int finish) {
        return bits << 32 - finish >>> 32 - finish + start << start;
    }

    private static final int mask$(int bitIndex) {
        return 1 << bitIndex;
    }

    private static final int mask$(int start, int finish) {
        if (finish == 0) {
            return 0;
        }
        int mask = -1;
        return mask << 32 - finish >>> 32 - finish + start << start;
    }

    private static final int maskZero$(int bitIndex) {
        return ~BitsInt.mask$(bitIndex);
    }

    private static final int maskZero$(int start, int finish) {
        return ~BitsInt.mask$(start, finish);
    }

    private static final void check(int bitIndex) {
        if (bitIndex < 0 || bitIndex >= 32) {
            throw new IllegalArgumentException("Illegal bit index: " + bitIndex);
        }
    }

    private static final void check(int start, int finish) {
        if (start < 0 || start >= 32) {
            throw new IllegalArgumentException("Illegal start: " + start);
        }
        if (finish < 0 || finish > 32) {
            throw new IllegalArgumentException("Illegal finish: " + finish);
        }
        if (start > finish) {
            throw new IllegalArgumentException("Illegal range: (" + start + ", " + finish + ")");
        }
    }
}

