/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.atlas.lib.InternalErrorException;

public class StrUtils {
    public static final int CMP_GREATER = 1;
    public static final int CMP_EQUAL = 0;
    public static final int CMP_LESS = -1;
    public static final int CMP_UNEQUAL = -9;
    public static final int CMP_INDETERMINATE = 2;

    private StrUtils() {
    }

    public static String strjoinNL(String ... args) {
        return String.join((CharSequence)"\n", args);
    }

    public static String strjoinNL(List<String> args) {
        return String.join((CharSequence)"\n", args);
    }

    public static <X> String strjoin(List<X> args, String sep) {
        return args.stream().map(obj -> obj.toString()).collect(Collectors.joining(sep));
    }

    public static int strCompare(String s1, String s2) {
        int x = s1.compareTo(s2);
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        if (x == 0) {
            return 0;
        }
        throw new InternalErrorException("String comparison failure");
    }

    public static int strCompareIgnoreCase(String s1, String s2) {
        int x = s1.compareToIgnoreCase(s2);
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        if (x == 0) {
            return 0;
        }
        throw new InternalErrorException("String comparison failure");
    }

    public static byte[] asUTF8bytes(String s2) {
        return s2.getBytes(StandardCharsets.UTF_8);
    }

    public static String fromUTF8bytes(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String str(Object x) {
        return Objects.toString(x, "<null>");
    }

    public static String[] split(String s2, String splitStr) {
        return (String[])Arrays.stream(s2.split(splitStr)).map(String::trim).toArray(String[]::new);
    }

    public static final boolean contains(String str1, String str2) {
        return str1.contains(str2);
    }

    public static final String replace(String string, String target, String replacement) {
        return string.replace(target, replacement);
    }

    public static String substitute(String str2, Map<String, String> subs) {
        for (Map.Entry<String, String> e2 : subs.entrySet()) {
            String param = e2.getKey();
            if (!str2.contains(param)) continue;
            str2 = str2.replace(param, e2.getValue());
        }
        return str2;
    }

    public static String strform(Map<String, String> subs, String ... args) {
        return StrUtils.substitute(StrUtils.strjoinNL(args), subs);
    }

    public static String chop(String x) {
        return x.isEmpty() ? x : x.substring(0, x.length() - 1);
    }

    public static String noNewlineEnding(String x) {
        while (x.endsWith("\n") || x.endsWith("\r")) {
            x = StrUtils.chop(x);
        }
        return x;
    }

    public static List<Character> toCharList(String str2) {
        return str2.codePoints().mapToObj(i -> Character.valueOf((char)i)).map(Character::new).collect(Collectors.toList());
    }

    public static String encodeHex(String str2, char marker, char[] escapees) {
        char ch;
        int idx;
        int N = str2.length();
        for (idx = 0; idx < N && !Chars.charInArray(ch = str2.charAt(idx), escapees); ++idx) {
        }
        if (idx == N) {
            return str2;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(str2, 0, idx);
        while (idx < N) {
            char ch2 = str2.charAt(idx);
            if (Chars.charInArray(ch2, escapees)) {
                Chars.encodeAsHex(buff, marker, ch2);
            } else {
                buff.append(ch2);
            }
            ++idx;
        }
        return buff.toString();
    }

    public static String decodeHex(String str2, char marker) {
        if (str2.indexOf(marker) < 0) {
            return str2;
        }
        byte[] strBytes = StrUtils.asUTF8bytes(str2);
        int N = strBytes.length;
        byte[] bytes = new byte[strBytes.length];
        int i = 0;
        for (int j = 0; j < N; ++j) {
            byte b = strBytes[j];
            if (b != marker) {
                bytes[i++] = b;
                continue;
            }
            if (j + 2 >= N) {
                throw new AtlasException("Decoding error: incomplete hex value. \"" + str2 + "\"");
            }
            byte hi = strBytes[j + 1];
            byte lo = strBytes[j + 2];
            j += 2;
            int x1 = StrUtils.hexDecode(hi);
            int x2 = StrUtils.hexDecode(lo);
            int ch2 = StrUtils.hexDecode(hi) << 4 | StrUtils.hexDecode(lo);
            bytes[i++] = (byte)ch2;
        }
        String s2 = new String(bytes, 0, i, StandardCharsets.UTF_8);
        return s2;
    }

    private static String _forInfo_decodeHex(String str2, char marker) {
        int idx = str2.indexOf(marker);
        if (idx == -1) {
            return str2;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(str2, 0, idx);
        int N = str2.length();
        while (idx < N) {
            char ch = str2.charAt(idx);
            if (ch != marker) {
                buff.append(ch);
            } else {
                if (idx + 2 >= N) {
                    throw new AtlasException("Decoding error: incomplete hex value. \"" + str2 + "\"");
                }
                char hi = str2.charAt(idx + 1);
                char lo = str2.charAt(idx + 2);
                char ch2 = (char)(StrUtils.hexDecode(hi) << 4 | StrUtils.hexDecode(lo));
                buff.append(ch2);
                idx += 2;
            }
            ++idx;
        }
        return buff.toString();
    }

    private static int hexDecode(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        throw new AtlasException(String.format("Decoding error: bad character for hex digit (0x%02X) '%c' ", ch, ch));
    }

    public static String escapeString(String x) {
        return EscapeStr.stringEsc(x);
    }

    public static String unescapeString(String x) {
        return EscapeStr.unescapeStr(x);
    }
}

