/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset.rw;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.json.io.JSWriter;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetWriter;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.riot.resultset.rw.JSONResultsKW;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;

public class ResultSetWriterJSON
implements ResultSetWriter {
    public static ResultSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.SPARQLResultSetJSON)) {
            throw new ResultSetException("ResultSetWriter for JSON asked for a " + lang);
        }
        return new ResultSetWriterJSON();
    };

    private ResultSetWriterJSON() {
    }

    @Override
    public void write(Writer out, ResultSet resultSet, Context context2) {
        throw new UnsupportedOperationException("Writing JSON results to a java.io.Writer. Use an OutputStream.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream outStream, boolean result, Context context2) {
        try {
            JSWriter out = new JSWriter(outStream);
            out.startOutput();
            out.startObject();
            out.key(JSONResultsKW.kHead);
            out.startObject();
            out.finishObject();
            out.pair(JSONResultsKW.kBoolean, result);
            out.finishObject();
            out.finishOutput();
        }
        finally {
            IO.flush(outStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream outStream, ResultSet resultSet, Context context2) {
        IndentedWriter out = new IndentedWriter(outStream);
        try {
            ResultSetWriterTableJSON x = new ResultSetWriterTableJSON(out, context2);
            x.write(resultSet);
        }
        finally {
            IO.flush(out);
        }
    }

    static class ResultSetWriterTableJSON {
        private final NodeToLabel labels;
        private final IndentedWriter out;
        private static final boolean MultiLineValues = false;
        private static final boolean MultiLineVarNames = false;
        private static final int MainIndent = 2;
        private static final int VarIndent = 2;
        private static final int OuterIndent = Math.min(2, 2);

        private ResultSetWriterTableJSON(OutputStream outStream, Context context2) {
            this(new IndentedWriter(outStream), context2);
        }

        private ResultSetWriterTableJSON(IndentedWriter indentedOut, Context context2) {
            this.out = indentedOut;
            this.out.setUnitIndent(2);
            boolean outputGraphBNodeLabels = context2 != null && context2.isTrue(ARQ.outputGraphBNodeLabels);
            this.labels = outputGraphBNodeLabels ? SyntaxLabels.createNodeToLabelAsGiven() : SyntaxLabels.createNodeToLabel();
        }

        private void write(ResultSet resultSet) {
            ResultSetWriterTableJSON.print(this.out, "{");
            this.out.incIndent(OuterIndent);
            this.writeHeader(resultSet);
            ResultSetWriterTableJSON.println(this.out, " ,");
            this.writeRows(this.out, resultSet);
            this.out.decIndent(OuterIndent);
            ResultSetWriterTableJSON.println(this.out, "}");
        }

        private void writeRows(IndentedWriter out2, ResultSet resultSet) {
            ResultSetWriterTableJSON.println(this.out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kResults), ": {");
            ResultSetWriterTableJSON.incIndent(this.out);
            ResultSetWriterTableJSON.println(this.out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kBindings), ": [");
            ResultSetWriterTableJSON.incIndent(this.out);
            boolean firstRow = true;
            while (resultSet.hasNext()) {
                Binding binding = resultSet.nextBinding();
                if (!firstRow) {
                    ResultSetWriterTableJSON.println(this.out, " ,");
                }
                this.writeRow(this.out, resultSet, binding);
                firstRow = false;
            }
            ResultSetWriterTableJSON.println(this.out, new String[0]);
            ResultSetWriterTableJSON.decIndent(this.out);
            ResultSetWriterTableJSON.println(this.out, "]");
            ResultSetWriterTableJSON.decIndent(this.out);
            ResultSetWriterTableJSON.println(this.out, "}");
        }

        private void writeHeader(ResultSet rs) {
            ResultSetWriterTableJSON.println(this.out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kHead), ": {");
            ResultSetWriterTableJSON.incIndent(this.out);
            ResultSetWriterTableJSON.writeHeaderLink(this.out, rs);
            ResultSetWriterTableJSON.writeHeaderVars(this.out, rs);
            ResultSetWriterTableJSON.decIndent(this.out);
            ResultSetWriterTableJSON.print(this.out, "}");
        }

        private static void writeHeaderLink(IndentedWriter out, ResultSet rs) {
        }

        private static void writeHeaderVars(IndentedWriter out, ResultSet rs) {
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kVars), ": [ ");
            ResultSetWriterTableJSON.incIndent(out);
            Iterator<String> iter = rs.getResultVars().iterator();
            while (iter.hasNext()) {
                String varname = iter.next();
                ResultSetWriterTableJSON.print(out, "\"", varname, "\"");
                if (!iter.hasNext()) continue;
                ResultSetWriterTableJSON.print(out, " , ");
            }
            ResultSetWriterTableJSON.decIndent(out);
            ResultSetWriterTableJSON.println(out, " ]");
        }

        private void writeRow(IndentedWriter out, ResultSet resultSet, Binding binding) {
            ResultSetWriterTableJSON.print(out, "{ ");
            out.incIndent(2);
            boolean firstInRow = true;
            Iterator<String> iter = resultSet.getResultVars().iterator();
            while (iter.hasNext()) {
                Var var = Var.alloc(iter.next());
                Node value = binding.get(var);
                if (value == null) continue;
                if (!firstInRow) {
                    ResultSetWriterTableJSON.print(out, " ,");
                }
                this.writeVarValue(out, var, value, firstInRow);
                firstInRow = false;
            }
            ResultSetWriterTableJSON.println(out, new String[0]);
            out.decIndent(2);
            ResultSetWriterTableJSON.print(out, "}");
        }

        private void writeVarValue(IndentedWriter out, Var var, Node value, boolean firstInRow) {
            if (value == null) {
                return;
            }
            ResultSetWriterTableJSON.println(out, new String[0]);
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quote(var.getVarName()), ": ");
            this.writeValue(out, value, false);
        }

        private void writeValue(IndentedWriter out, Node value, boolean multiLine) {
            if (multiLine || value.isNodeTriple()) {
                ResultSetWriterTableJSON.println(out, "{");
            } else {
                ResultSetWriterTableJSON.print(out, "{ ");
            }
            ResultSetWriterTableJSON.incIndent(out);
            if (value.isLiteral()) {
                this.writeValueLiteral(out, value, multiLine);
            } else if (value.isURI()) {
                this.writeValueURI(out, value, multiLine);
            } else if (value.isBlank()) {
                this.writeValueBlankNode(out, value, multiLine);
            } else if (value.isNodeTriple()) {
                this.writeValueNodeTriple(out, value, multiLine);
            } else if (value.isNodeGraph()) {
                this.writeValueNodeGraph(out, value, multiLine);
            } else {
                Log.warn(ResultSetWriterJSON.class, "Unknown RDFNode type in result set: " + value.getClass());
            }
            if (multiLine || value.isNodeTriple()) {
                ResultSetWriterTableJSON.println(out, new String[0]);
            } else {
                ResultSetWriterTableJSON.print(out, " ");
            }
            ResultSetWriterTableJSON.decIndent(out);
            ResultSetWriterTableJSON.print(out, "}");
        }

        private void writeValueUnbound(IndentedWriter out, boolean multiLine) {
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kType), ": ", ResultSetWriterTableJSON.quote(JSONResultsKW.kUnbound), " , ");
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kValue), ": null");
        }

        private void writeValueLiteral(IndentedWriter out, Node literal, boolean multiLine) {
            String datatype = literal.getLiteralDatatypeURI();
            String lang = literal.getLiteralLanguage();
            if (Util.isSimpleString(literal) || Util.isLangString(literal)) {
                ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kType), ": ", ResultSetWriterTableJSON.quote(JSONResultsKW.kLiteral), " , ");
                if (multiLine) {
                    ResultSetWriterTableJSON.println(out, new String[0]);
                }
                if (lang != null && !lang.equals("")) {
                    ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kXmlLang), ": ", ResultSetWriterTableJSON.quote(lang), " , ");
                    if (multiLine) {
                        ResultSetWriterTableJSON.println(out, new String[0]);
                    }
                }
            } else {
                ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kType), ": ", ResultSetWriterTableJSON.quote(JSONResultsKW.kLiteral), " , ");
                ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kDatatype), ": ", ResultSetWriterTableJSON.quote(datatype), " , ");
                if (multiLine) {
                    ResultSetWriterTableJSON.println(out, new String[0]);
                }
            }
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kValue), ": ", ResultSetWriterTableJSON.quote(literal.getLiteralLexicalForm()));
        }

        private void writeValueBlankNode(IndentedWriter out, Node resource, boolean multiLine) {
            String label = (String)this.labels.get(null, resource);
            label = label.substring(2);
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kType), ": ", ResultSetWriterTableJSON.quote(JSONResultsKW.kBnode), " , ");
            if (multiLine) {
                ResultSetWriterTableJSON.println(out, new String[0]);
            }
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kValue), ": ", ResultSetWriterTableJSON.quote(label));
        }

        private void writeValueURI(IndentedWriter out, Node resource, boolean multiLine) {
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kType), ": ", ResultSetWriterTableJSON.quote(JSONResultsKW.kUri), " , ");
            if (multiLine) {
                ResultSetWriterTableJSON.println(out, new String[0]);
            }
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kValue), ": ", ResultSetWriterTableJSON.quote(resource.getURI()));
        }

        private void writeValueNodeTriple(IndentedWriter out, Node value, boolean multiLine) {
            Triple triple = Node_Triple.triple(value);
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kType), ": ", ResultSetWriterTableJSON.quote(JSONResultsKW.kTriple), " , ");
            ResultSetWriterTableJSON.println(out, new String[0]);
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kValue), ": ");
            boolean multiLineInnerValue = multiLine;
            ResultSetWriterTableJSON.println(out, "{");
            ResultSetWriterTableJSON.incIndent(out);
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kSubject), ": ");
            ResultSetWriterTableJSON.print(out, " ");
            this.writeValue(out, triple.getSubject(), multiLineInnerValue);
            ResultSetWriterTableJSON.println(out, " ,");
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kProperty), ": ");
            this.writeValue(out, triple.getPredicate(), multiLineInnerValue);
            ResultSetWriterTableJSON.println(out, " ,");
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName(JSONResultsKW.kObject), ": ");
            ResultSetWriterTableJSON.print(out, "  ");
            this.writeValue(out, triple.getObject(), multiLineInnerValue);
            ResultSetWriterTableJSON.decIndent(out);
            ResultSetWriterTableJSON.println(out, new String[0]);
            ResultSetWriterTableJSON.print(out, "}");
        }

        private void writeValueNodeGraph(IndentedWriter out, Node value, boolean multiLine) {
            throw new UnsupportedOperationException("Graph terms");
        }

        private static String quote(String string) {
            return JSWriter.outputQuotedString(string);
        }

        private static String quoteName(String string) {
            return ResultSetWriterTableJSON.quote(string);
        }

        private static void incIndent(IndentedWriter out) {
            out.incIndent();
        }

        private static void decIndent(IndentedWriter out) {
            out.decIndent();
        }

        private static void print(IndentedWriter out, String ... strings) {
            for (String s2 : strings) {
                out.print(s2);
            }
        }

        private static void println(IndentedWriter out, String ... strings) {
            ResultSetWriterTableJSON.print(out, strings);
            out.println();
        }
    }
}

