/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.mem.PMapQuadTable;
import org.apache.jena.sparql.core.mem.QuadTable;
import org.apache.jena.sparql.core.mem.QuadTableForm;
import org.apache.jena.sparql.core.mem.TransactionalComponent;
import org.apache.jena.sparql.core.mem.TupleSlot;

public class HexTable
implements QuadTable {
    private final Map<QuadTableForm, QuadTable> indexBlock = new EnumMap<QuadTableForm, PMapQuadTable>(QuadTableForm.tableForms().collect(Collectors.toMap(x -> x, QuadTableForm::get)));

    protected Map<QuadTableForm, QuadTable> indexBlock() {
        return this.indexBlock;
    }

    @Override
    public Stream<Quad> find(Node g2, Node s2, Node p, Node o) {
        EnumSet<TupleSlot> pattern = EnumSet.noneOf(TupleSlot.class);
        if (HexTable.isConcrete(g2)) {
            pattern.add(TupleSlot.GRAPH);
        }
        if (HexTable.isConcrete(s2)) {
            pattern.add(TupleSlot.SUBJECT);
        }
        if (HexTable.isConcrete(p)) {
            pattern.add(TupleSlot.PREDICATE);
        }
        if (HexTable.isConcrete(o)) {
            pattern.add(TupleSlot.OBJECT);
        }
        QuadTableForm choice = QuadTableForm.chooseFrom(pattern);
        return this.indexBlock().get(choice).find(g2, s2, p, o);
    }

    private static boolean isConcrete(Node n) {
        return Objects.nonNull(n) && n.isConcrete();
    }

    @Override
    public void add(Quad q) {
        this.indexBlock().values().forEach(index -> index.add(q));
    }

    @Override
    public void delete(Quad q) {
        this.indexBlock().values().forEach(index -> index.delete(q));
    }

    @Override
    public Stream<Node> listGraphNodes() {
        return this.indexBlock().get(QuadTableForm.GSPO).listGraphNodes();
    }

    @Override
    public Stream<Quad> findInUnionGraph(Node s2, Node p, Node o) {
        return this.indexBlock().get(QuadTableForm.SPOG).findInUnionGraph(s2, p, o);
    }

    @Override
    public void begin(ReadWrite rw) {
        this.indexBlock().values().forEach(table -> table.begin(rw));
    }

    @Override
    public void end() {
        this.indexBlock().values().forEach(TransactionalComponent::end);
    }

    @Override
    public void commit() {
        this.indexBlock().values().forEach(TransactionalComponent::commit);
    }

    @Override
    public void clear() {
        this.indexBlock().values().forEach(QuadTable::clear);
    }
}

