/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.metrics;

import com.sun.net.httpserver.HttpServer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PrometheusActuator {
    private final ExecutorService executor;
    private HttpServer server;
    private PrometheusMeterRegistry registry;

    public PrometheusActuator(boolean enableMetrics) {
        if (enableMetrics) {
            this.configureRegistry();
            this.configureServer();
        }
        this.executor = Executors.newSingleThreadExecutor();
    }

    private void configureRegistry() {
        this.registry = new PrometheusMeterRegistry(new PrometheusConfig(){

            @Override
            public Duration step() {
                return Duration.ofSeconds(10L);
            }

            @Override
            public String get(String key) {
                return null;
            }
        });
        this.registry.config().meterFilter(new MeterFilter(){

            @Override
            public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
                if (id.getType() == Meter.Type.TIMER) {
                    return new DistributionStatisticConfig.Builder().percentilesHistogram(true).percentiles(0.9, 0.95, 0.99).build().merge(config);
                }
                return config;
            }
        });
        new JvmGcMetrics().bindTo(this.registry);
        new JvmMemoryMetrics().bindTo(this.registry);
        new JvmThreadMetrics().bindTo(this.registry);
        new ProcessorMetrics().bindTo(this.registry);
        new ClassLoaderMetrics().bindTo(this.registry);
        Metrics.addRegistry(this.registry);
    }

    private void configureServer() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(8080), 0);
        }
        catch (IOException e2) {
            throw new RuntimeException("Unable to start http server for publishing metrics!", e2);
        }
        this.server.setExecutor(this.executor);
        this.server.createContext("/prometheus", handler -> {
            String response = this.registry.scrape();
            handler.sendResponseHeaders(200, response.getBytes().length);
            try (OutputStream os = handler.getResponseBody();){
                os.write(response.getBytes());
            }
        });
    }

    public void start() {
        if (this.server != null) {
            this.server.start();
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
        }
        this.executor.shutdown();
    }
}

