/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.ocfl.exception;

import java.util.Collection;
import java.util.Objects;

public class ValidationException
extends RuntimeException {
    private final String resourceId;
    private final String ocflObjectId;
    private final Collection<String> problems;
    private String message;

    public static ValidationException create(Collection<String> problems) {
        return new ValidationException(null, null, problems);
    }

    public static ValidationException createForResource(String resourceId, Collection<String> problems) {
        return new ValidationException(null, resourceId, problems);
    }

    public static ValidationException createForObject(String ocflObjectId, Collection<String> problems) {
        return new ValidationException(ocflObjectId, null, problems);
    }

    private ValidationException(String ocflObjectId, String resourceId, Collection<String> problems) {
        this.ocflObjectId = ocflObjectId;
        this.resourceId = resourceId;
        this.problems = Objects.requireNonNull(problems, "problems cannot be null");
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            StringBuilder builder = new StringBuilder();
            if (this.ocflObjectId != null) {
                builder.append("OCFL object ").append(this.ocflObjectId).append(" is not a valid Fedora 6 object. ");
            }
            if (this.resourceId != null) {
                builder.append("Resource ").append(this.resourceId).append(" is not a valid Fedora 6 resource. ");
            }
            builder.append("The following problems were identified:");
            int index = 1;
            for (String problem : this.problems) {
                builder.append("\n  ").append(index++).append(". ");
                builder.append(problem);
            }
            this.message = builder.toString();
        }
        return this.message;
    }

    public Collection<String> getProblems() {
        return this.problems;
    }
}

