/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.ocfl.validation;

import java.util.Objects;
import java.util.Set;
import org.fcrepo.storage.ocfl.InteractionModel;
import org.fcrepo.storage.ocfl.PersistencePaths;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.fcrepo.storage.ocfl.validation.Context;
import org.fcrepo.storage.ocfl.validation.HeadersValidator;
import org.fcrepo.storage.ocfl.validation.ValidationUtil;

public class DefaultHeadersValidator
implements HeadersValidator {
    private static final Set<String> VALID_EXT_HANDLING = Set.of("proxy", "redirect");

    @Override
    public void validate(PersistencePaths paths, ResourceHeaders headers, ResourceHeaders rootHeaders) {
        Objects.requireNonNull(headers, "headers may not be null");
        Objects.requireNonNull(rootHeaders, "rootHeaders may not be null");
        Context context2 = new Context();
        this.generalHeaderValidation(context2, paths, headers, rootHeaders);
        this.nonRdfHeaderValidation(context2, headers);
        if (!Objects.equals(headers.getId(), rootHeaders.getId())) {
            ValidationUtil.requireValue(context2, "objectRoot", false, headers.isObjectRoot());
            ValidationUtil.requireValue(context2, "archivalGroup", false, headers.isArchivalGroup());
            if (rootHeaders.isArchivalGroup()) {
                this.validateArchivalPartHeaders(context2, headers, rootHeaders);
            } else {
                this.validateAtomicPartHeaders(context2, headers);
            }
        } else {
            this.validateRootHeaders(context2, headers);
        }
        context2.throwValidationException();
    }

    private void validateRootHeaders(Context context2, ResourceHeaders headers) {
        String model = headers.getInteractionModel();
        if (ValidationUtil.isModel(InteractionModel.ACL, model) || ValidationUtil.isModel(InteractionModel.NON_RDF_DESCRIPTION, model)) {
            context2.problem("Invalid interaction model value: %s.", model);
        }
        ValidationUtil.requireValue(context2, "objectRoot", true, headers.isObjectRoot());
        ValidationUtil.requireValue(context2, "archivalGroupId", null, headers.getArchivalGroupId());
        if (headers.isArchivalGroup() && !ValidationUtil.isContainer(model)) {
            context2.problem("Archival Group has an invalid interaction model: %s", model);
        }
    }

    private void generalHeaderValidation(Context context2, PersistencePaths paths, ResourceHeaders headers, ResourceHeaders rootHeaders) {
        ValidationUtil.requireValue(context2, "headersVersion", "1.0", headers.getHeadersVersion());
        ValidationUtil.validateId(context2, "id", headers.getId());
        ValidationUtil.validateId(context2, "parent", headers.getParent());
        ValidationUtil.validateIdRelationship(context2, "parent", headers.getParent(), "id", headers.getId());
        ValidationUtil.validateIdRelationship(context2, "rootId", rootHeaders.getId(), "id", headers.getId());
        ValidationUtil.requireNotNull(context2, "stateToken", headers.getStateToken());
        ValidationUtil.validateInteractionModel(context2, headers.getInteractionModel());
        ValidationUtil.requireNotNull(context2, "createdDate", headers.getCreatedDate());
        ValidationUtil.requireNotNull(context2, "lastModifiedDate", headers.getLastModifiedDate());
        boolean contentExpected = ValidationUtil.contentExpected(headers);
        if (paths != null && contentExpected) {
            ValidationUtil.requireValue(context2, "contentPath", paths.getContentFilePath(), headers.getContentPath());
        }
        if (rootHeaders.isDeleted()) {
            ValidationUtil.requireValue(context2, "deleted", rootHeaders.isDeleted(), headers.isDeleted());
        }
        if (contentExpected) {
            ValidationUtil.requireNotEmpty(context2, "digests", headers.getDigests());
        }
        ValidationUtil.validateDigests(context2, headers.getDigests());
    }

    private void nonRdfHeaderValidation(Context context2, ResourceHeaders headers) {
        if (!headers.isDeleted() && ValidationUtil.isModel(InteractionModel.NON_RDF, headers.getInteractionModel())) {
            ValidationUtil.requireNotNull(context2, "mimeType", headers.getMimeType());
        }
        if (headers.getExternalHandling() != null || headers.getExternalUrl() != null) {
            ValidationUtil.requireNotNull(context2, "externalUrl", headers.getExternalUrl());
            if (headers.getExternalHandling() == null || !VALID_EXT_HANDLING.contains(headers.getExternalHandling())) {
                context2.problem("Must define property 'externalHandling' as one of %s", VALID_EXT_HANDLING);
            }
            ValidationUtil.requireValue(context2, "interactionModel", InteractionModel.NON_RDF.getUri(), headers.getInteractionModel());
        }
    }

    private void validateArchivalPartHeaders(Context context2, ResourceHeaders headers, ResourceHeaders rootHeaders) {
        ValidationUtil.requireValue(context2, "archivalGroupId", rootHeaders.getId(), headers.getArchivalGroupId());
    }

    private void validateAtomicPartHeaders(Context context2, ResourceHeaders headers) {
        String model = headers.getInteractionModel();
        if (!ValidationUtil.isModel(InteractionModel.ACL, model) && !ValidationUtil.isModel(InteractionModel.NON_RDF_DESCRIPTION, model)) {
            context2.problem("Invalid interaction model %s. Atomic resources may only contain ACLs and non-RDF descriptions.", model);
        } else if (headers.getParent() != null) {
            if (ValidationUtil.isModel(InteractionModel.ACL, model)) {
                ValidationUtil.requireValue(context2, "id", headers.getParent() + "/fcr:acl", headers.getId());
            } else {
                ValidationUtil.requireValue(context2, "id", headers.getParent() + "/fcr:metadata", headers.getId());
            }
        }
        ValidationUtil.requireValue(context2, "archivalGroupId", null, headers.getArchivalGroupId());
    }
}

