/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.api.model;

import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.model.InventoryType;
import java.util.Arrays;

public enum OcflVersion {
    OCFL_1_0("1.0");

    private static final String OCFL_PREFIX = "ocfl_";
    private static final String OBJECT_PREFIX = "ocfl_object_";
    private final String versionString;

    private OcflVersion(String versionString) {
        this.versionString = versionString;
    }

    public String getOcflVersion() {
        return OCFL_PREFIX + this.versionString;
    }

    public String getOcflObjectVersion() {
        return OBJECT_PREFIX + this.versionString;
    }

    public InventoryType getInventoryType() {
        switch (this.versionString) {
            case "1.0": {
                return InventoryType.OCFL_1_0;
            }
        }
        throw new OcflJavaException("Unmapped version " + this.versionString);
    }

    public String toString() {
        return this.getOcflVersion();
    }

    public static OcflVersion fromOcflVersionString(String ocflVersionString) {
        for (OcflVersion version2 : OcflVersion.values()) {
            if (!version2.getOcflVersion().equals(ocflVersionString)) continue;
            return version2;
        }
        throw new OcflJavaException(String.format("Unable to map string '%s' to a known OCFL version. Known versions: %s", ocflVersionString, Arrays.asList(OcflVersion.values())));
    }
}

