/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang.extra;

import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.lang.extra.javacc.ParseException;
import org.apache.jena.riot.lang.extra.javacc.TokenMgrError;
import org.apache.jena.riot.lang.extra.javacc.TurtleJavacc;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.Context;

public class TurtleJavaccReaderRIOT
implements ReaderRIOT {
    public static Lang lang = LangBuilder.create("TurtleJavaCC", "text/turtle-jcc").addFileExtensions("ttljcc").build();
    private final ParserProfile profile;
    private static ReaderRIOTFactory factory = (language, profile2) -> new TurtleJavaccReaderRIOT(profile2);

    public static void register() {
        RDFLanguages.register(lang);
        RDFParserRegistry.registerLangTriples(lang, factory);
    }

    public static void unregister() {
        RDFParserRegistry.removeRegistration(lang);
        RDFLanguages.unregister(lang);
    }

    public TurtleJavaccReaderRIOT(ParserProfile profile2) {
        this.profile = profile2;
    }

    @Override
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        TurtleJavacc parser = new TurtleJavacc(in);
        parser.setDest(output);
        parser.setProfile(this.profile);
        try {
            output.start();
            parser.parse();
            output.finish();
        }
        catch (QueryParseException ex) {
            throw new RiotParseException(ex.getMessage(), ex.getLine(), ex.getColumn());
        }
        catch (ParseException ex) {
            throw new RiotParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError ex) {
            throw new RiotParseException(ex.getMessage(), -1L, -1L);
        }
    }

    @Override
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        TurtleJavacc parser = new TurtleJavacc(reader);
        parser.setDest(output);
        parser.setProfile(this.profile);
        try {
            output.start();
            parser.parse();
            output.finish();
        }
        catch (QueryParseException ex) {
            throw new RiotParseException(ex.getMessage(), ex.getLine(), ex.getColumn());
        }
        catch (ParseException ex) {
            throw new RiotParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError ex) {
            throw new RiotParseException(ex.getMessage(), -1L, -1L);
        }
    }
}

