/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpFind;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.algebra.optimize.TransformSimplify;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.path.PathLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementExists;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementFind;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementNotExists;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.util.Context;

public class AlgebraGenerator {
    private final Context context;
    private final int subQueryDepth;
    private static final boolean fixedFilterPosition = false;
    private static final boolean applySimplification = true;
    private static final boolean simplifyTooEarlyInAlgebraGeneration = false;
    protected static Transform simplify = new TransformSimplify();

    public AlgebraGenerator(Context context2) {
        this(context2 != null ? context2 : ARQ.getContext().copy(), 0);
    }

    public AlgebraGenerator() {
        this(null);
    }

    protected AlgebraGenerator(Context context2, int depth) {
        this.context = context2;
        this.subQueryDepth = depth;
    }

    public Op compile(Query query) {
        Op op = this.compile(query.getQueryPattern());
        op = this.compileModifiers(query, op);
        return op;
    }

    public Op compile(Element elt) {
        Op op;
        Op op2 = op = this.compileElement(elt);
        if (simplify != null) {
            op2 = AlgebraGenerator.simplify(op);
        }
        return op2;
    }

    protected static Op simplify(Op op) {
        return Transformer.transform(simplify, op);
    }

    protected Op compileElement(Element elt) {
        if (elt instanceof ElementGroup) {
            return this.compileElementGroup((ElementGroup)elt);
        }
        if (elt instanceof ElementUnion) {
            return this.compileElementUnion((ElementUnion)elt);
        }
        if (elt instanceof ElementNamedGraph) {
            return this.compileElementGraph((ElementNamedGraph)elt);
        }
        if (elt instanceof ElementService) {
            return this.compileElementService((ElementService)elt);
        }
        if (elt instanceof ElementTriplesBlock) {
            return this.compileBasicPattern(((ElementTriplesBlock)elt).getPattern());
        }
        if (elt instanceof ElementFind) {
            return this.compileFind((ElementFind)elt);
        }
        if (elt instanceof ElementPathBlock) {
            return this.compilePathBlock(((ElementPathBlock)elt).getPattern());
        }
        if (elt instanceof ElementSubQuery) {
            return this.compileElementSubquery((ElementSubQuery)elt);
        }
        if (elt instanceof ElementData) {
            return this.compileElementData((ElementData)elt);
        }
        if (elt == null) {
            return OpNull.create();
        }
        return this.compileUnknownElement(elt, "compile(Element)/Not a structural element: " + Lib.className(elt));
    }

    protected Op compileUnknownElement(Element elt, String error) {
        this.broken(error);
        return null;
    }

    protected Op compileElementGroup(ElementGroup groupElt) {
        Pair<List<Expr>, List<Element>> pair = this.prepareGroup(groupElt);
        List<Expr> filters = pair.getLeft();
        List<Element> groupElts = pair.getRight();
        Op current = OpTable.unit();
        ArrayDeque<Op> acc = new ArrayDeque<Op>();
        for (Element elt : groupElts) {
            if (elt == null) continue;
            current = this.compileOneInGroup(elt, current, acc);
        }
        if (filters != null) {
            for (Expr expr : filters) {
                current = OpFilter.filter(expr, current);
            }
        }
        return current;
    }

    protected Pair<List<Expr>, List<Element>> prepareGroup(ElementGroup groupElt) {
        ArrayList<Object> groupElts = new ArrayList<Object>();
        PathBlock currentPathBlock = null;
        ArrayList<Expr> filters = null;
        for (Element elt : groupElt.getElements()) {
            Object etb2;
            if (elt instanceof ElementFilter) {
                ElementFilter f = (ElementFilter)elt;
                if (filters == null) {
                    filters = new ArrayList<Expr>();
                }
                filters.add(f.getExpr());
                continue;
            }
            if (elt instanceof ElementTriplesBlock) {
                ElementTriplesBlock etb = (ElementTriplesBlock)elt;
                if (currentPathBlock == null) {
                    etb2 = new ElementPathBlock();
                    currentPathBlock = ((ElementPathBlock)etb2).getPattern();
                    groupElts.add(etb2);
                }
                for (Triple t : etb.getPattern()) {
                    currentPathBlock.add(new TriplePath(t));
                }
                continue;
            }
            if (elt instanceof ElementPathBlock) {
                ElementPathBlock epb = (ElementPathBlock)elt;
                if (currentPathBlock == null) {
                    etb2 = new ElementPathBlock();
                    currentPathBlock = ((ElementPathBlock)etb2).getPattern();
                    groupElts.add(etb2);
                }
                currentPathBlock.addAll(epb.getPattern());
                continue;
            }
            currentPathBlock = null;
            groupElts.add(elt);
        }
        return Pair.create(filters, groupElts);
    }

    protected Op compileOneInGroup(Element elt, Op current, Deque<Op> acc) {
        if (elt instanceof ElementAssign) {
            ElementAssign assign2 = (ElementAssign)elt;
            return OpAssign.assign(current, assign2.getVar(), assign2.getExpr());
        }
        if (elt instanceof ElementBind) {
            ElementBind bind = (ElementBind)elt;
            return OpExtend.create(current, bind.getVar(), bind.getExpr());
        }
        if (elt instanceof ElementOptional) {
            ElementOptional eltOpt = (ElementOptional)elt;
            return this.compileElementOptional(eltOpt, current);
        }
        if (elt instanceof ElementMinus) {
            ElementMinus elt2 = (ElementMinus)elt;
            Op op = this.compileElementMinus(current, elt2);
            return op;
        }
        if (elt instanceof ElementGroup || elt instanceof ElementNamedGraph || elt instanceof ElementService || elt instanceof ElementUnion || elt instanceof ElementSubQuery || elt instanceof ElementData || elt instanceof ElementTriplesBlock || elt instanceof ElementPathBlock || elt instanceof ElementFind) {
            Op op = this.compileElement(elt);
            return AlgebraGenerator.join(current, op);
        }
        if (elt instanceof ElementExists) {
            ElementExists elt2 = (ElementExists)elt;
            Op op = this.compileElementExists(current, elt2);
            return op;
        }
        if (elt instanceof ElementNotExists) {
            ElementNotExists elt2 = (ElementNotExists)elt;
            Op op = this.compileElementNotExists(current, elt2);
            return op;
        }
        if (elt instanceof ElementFilter) {
            ElementFilter f = (ElementFilter)elt;
            return OpFilter.filter(f.getExpr(), current);
        }
        return this.compileUnknownElement(elt, "compile/Element not recognized: " + Lib.className(elt));
    }

    protected Op compileElementUnion(ElementUnion el) {
        Op current = null;
        for (Element subElt : el.getElements()) {
            Op op = this.compileElement(subElt);
            current = this.union(current, op);
        }
        return current;
    }

    protected Op compileElementNotExists(Op current, ElementNotExists elt2) {
        Op op = this.compile(elt2.getElement());
        ExprFunction expr = new E_Exists(elt2, op);
        expr = new E_LogicalNot(expr);
        return OpFilter.filter(expr, current);
    }

    protected Op compileElementExists(Op current, ElementExists elt2) {
        Op op = this.compile(elt2.getElement());
        E_Exists expr = new E_Exists(elt2, op);
        return OpFilter.filter(expr, current);
    }

    protected Op compileElementMinus(Op current, ElementMinus elt2) {
        Op op = this.compile(elt2.getMinusElement());
        Op opMinus = OpMinus.create(current, op);
        return opMinus;
    }

    protected Op compileElementData(ElementData elt) {
        return OpTable.create(elt.getTable());
    }

    protected Op compileElementUnion(Op current, ElementUnion elt2) {
        Op op = this.compile(elt2.getElements().get(0));
        Op opUnion = OpUnion.create(current, op);
        return opUnion;
    }

    protected Op compileElementOptional(ElementOptional eltOpt, Op current) {
        Element subElt = eltOpt.getOptionalElement();
        Op op = this.compileElement(subElt);
        ExprList exprs = null;
        if (op instanceof OpFilter) {
            OpFilter f = (OpFilter)op;
            Op sub = f.getSubOp();
            if (sub instanceof OpFilter) {
                this.broken("compile/Optional/nested filters - unfinished");
            }
            exprs = f.getExprs();
            op = sub;
        }
        current = OpLeftJoin.create(current, op, exprs);
        return current;
    }

    protected Op compileBasicPattern(BasicPattern pattern) {
        return new OpBGP(pattern);
    }

    protected Op compilePathBlock(PathBlock pathBlock) {
        if (pathBlock.size() == 0) {
            return OpTable.unit();
        }
        return PathLib.pathToTriples(pathBlock);
    }

    protected Op compileFind(ElementFind elFind) {
        Var var = elFind.getVar();
        Triple triple = elFind.getTriple();
        return new OpFind(triple, var);
    }

    protected Op compileElementGraph(ElementNamedGraph eltGraph) {
        Node graphNode = eltGraph.getGraphNameNode();
        Op sub = this.compileElement(eltGraph.getElement());
        return new OpGraph(graphNode, sub);
    }

    protected Op compileElementService(ElementService eltService) {
        Node serviceNode = eltService.getServiceNode();
        Op sub = this.compileElement(eltService.getElement());
        return new OpService(serviceNode, sub, eltService, eltService.getSilent());
    }

    protected Op compileElementSubquery(ElementSubQuery eltSubQuery) {
        AlgebraGenerator gen = new AlgebraGenerator(this.context, this.subQueryDepth + 1);
        return gen.compile(eltSubQuery.getQuery());
    }

    protected Op compileModifiers(Query query, Op pattern) {
        VarExprList projectVars = query.getProject();
        VarExprList exprs = new VarExprList();
        ArrayList<Var> vars = new ArrayList<Var>();
        Op op = pattern;
        if (query.hasGroupBy()) {
            op = OpGroup.create(op, query.getGroupBy(), query.getAggregators());
        }
        if (!projectVars.isEmpty() && !query.isQueryResultStar()) {
            if (projectVars.size() == 0 && query.isSelectType()) {
                Log.warn(this, "No project variables");
            }
            for (Var var : query.getProject().getVars()) {
                Expr e2 = query.getProject().getExpr(var);
                if (e2 != null) {
                    Expr e22 = ExprLib.replaceAggregateByVariable(e2);
                    exprs.add(var, e22);
                }
                vars.add(var);
            }
        }
        for (Var var : exprs.getVars()) {
            Expr e2 = exprs.getExpr(var);
            op = OpExtend.create(op, var, e2);
        }
        if (query.hasHaving()) {
            for (Expr expr : query.getHavingExprs()) {
                Expr expr2 = ExprLib.replaceAggregateByVariable(expr);
                op = OpFilter.filter(expr2, op);
            }
        }
        if (query.hasValues()) {
            Table table = TableFactory.create(query.getValuesVariables());
            for (Binding binding : query.getValuesData()) {
                table.addBinding(binding);
            }
            OpTable opTable = OpTable.create(table);
            op = OpJoin.create(op, opTable);
        }
        if (this.context.isTrue(ARQ.generateToList)) {
            op = new OpList(op);
        }
        if (query.getOrderBy() != null) {
            ArrayList<SortCondition> scList = new ArrayList<SortCondition>();
            for (SortCondition sc : query.getOrderBy()) {
                Expr e3 = sc.getExpression();
                e3 = ExprLib.replaceAggregateByVariable(e3);
                scList.add(new SortCondition(e3, sc.getDirection()));
            }
            op = new OpOrder(op, scList);
        }
        if (vars.size() > 0) {
            op = new OpProject(op, vars);
        }
        if (query.isDistinct()) {
            op = OpDistinct.create(op);
        }
        if (query.isReduced()) {
            op = OpReduced.create(op);
        }
        if (query.hasLimit() || query.hasOffset()) {
            op = new OpSlice(op, query.getOffset(), query.getLimit());
        }
        return op;
    }

    protected static Op join(Op current, Op newOp) {
        return OpJoin.create(current, newOp);
    }

    protected Op sequence(Op current, Op newOp) {
        return OpSequence.create(current, newOp);
    }

    protected Op union(Op current, Op newOp) {
        return OpUnion.create(current, newOp);
    }

    protected final void broken(String msg) {
        throw new ARQInternalErrorException(msg);
    }
}

