/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.riot.other.G;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphBaseFind;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TxnDataset2Graph;
import org.apache.jena.sparql.graph.GraphOps;
import org.apache.jena.sparql.graph.GraphZero;

public class DatasetGraphOne
extends DatasetGraphBaseFind {
    private final Graph graph;
    private final DatasetGraph backingDGS;
    private final Transactional txn;
    private final boolean supportsAbort;

    public static DatasetGraph create(Graph graph) {
        Graph graph2 = DatasetGraphOne.unwrap(graph);
        if (graph2 instanceof GraphView) {
            return new DatasetGraphOne(graph, ((GraphView)graph2).getDataset());
        }
        return new DatasetGraphOne(graph);
    }

    private static Graph unwrap(Graph graph) {
        while (true) {
            if (graph instanceof InfGraph) {
                graph = ((InfGraph)graph).getRawGraph();
                continue;
            }
            Graph graph2 = GraphOps.unwrapOne(graph);
            if (graph2 == graph) {
                return graph;
            }
            graph = graph2;
        }
    }

    private DatasetGraphOne(Graph graph, DatasetGraph backing) {
        this.graph = graph;
        this.backingDGS = backing;
        this.supportsAbort = backing.supportsTransactionAbort();
        this.txn = backing;
    }

    private DatasetGraphOne(Graph graph) {
        this.graph = graph;
        this.txn = new TxnDataset2Graph(graph, new Graph[0]);
        this.backingDGS = null;
        this.supportsAbort = false;
    }

    @Override
    public void begin(TxnType txnType) {
        this.txn.begin(txnType);
    }

    @Override
    public void begin(ReadWrite mode) {
        this.txn.begin(mode);
    }

    @Override
    public void commit() {
        this.txn.commit();
    }

    @Override
    public boolean promote(Transactional.Promote txnType) {
        return this.txn.promote(txnType);
    }

    @Override
    public void abort() {
        this.txn.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.txn.isInTransaction();
    }

    @Override
    public void end() {
        this.txn.end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.txn.transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.txn.transactionType();
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return this.supportsAbort;
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return DatasetGraphOne.isDefaultGraph(graphNode);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.graph;
    }

    @Override
    public Graph getUnionGraph() {
        return GraphZero.instance();
    }

    @Override
    public Graph getGraph(Node graphNode) {
        if (DatasetGraphOne.isDefaultGraph(graphNode)) {
            return this.getDefaultGraph();
        }
        if (Quad.isUnionGraph(graphNode)) {
            return this.getUnionGraph();
        }
        return null;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return new NullIterator<Node>();
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public void add(Node g2, Node s2, Node p, Node o) {
        if (Quad.isDefaultGraph(g2)) {
            this.graph.add(new Triple(s2, p, o));
        } else {
            DatasetGraphOne.unsupportedMethod(this, "add(named graph)");
        }
    }

    @Override
    public void add(Quad quad) {
        if (DatasetGraphOne.isDefaultGraph(quad)) {
            this.graph.add(quad.asTriple());
        } else {
            DatasetGraphOne.unsupportedMethod(this, "add(named graph)");
        }
    }

    @Override
    public void delete(Node g2, Node s2, Node p, Node o) {
        if (Quad.isDefaultGraph(g2)) {
            this.graph.delete(new Triple(s2, p, o));
        } else {
            DatasetGraphOne.unsupportedMethod(this, "delete(named graph)");
        }
    }

    @Override
    public void delete(Quad quad) {
        if (DatasetGraphOne.isDefaultGraph(quad)) {
            this.graph.delete(quad.asTriple());
        } else {
            DatasetGraphOne.unsupportedMethod(this, "delete(named graph)");
        }
    }

    @Override
    public void setDefaultGraph(Graph g2) {
        DatasetGraphOne.unsupportedMethod(this, "setDefaultGraph");
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        DatasetGraphOne.unsupportedMethod(this, "addGraph");
    }

    @Override
    public void removeGraph(Node graphName) {
        DatasetGraphOne.unsupportedMethod(this, "removeGraph");
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s2, Node p, Node o) {
        return G.triples2quadsDftGraph(this.graph.find(s2, p, o));
    }

    @Override
    protected Iterator<Quad> findInSpecificNamedGraph(Node g2, Node s2, Node p, Node o) {
        return Iter.nullIterator();
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s2, Node p, Node o) {
        return Iter.nullIterator();
    }

    protected static boolean isDefaultGraph(Quad quad) {
        return DatasetGraphOne.isDefaultGraph(quad.getGraph());
    }

    protected static boolean isDefaultGraph(Node quadGraphNode) {
        return quadGraphNode == null || Quad.isDefaultGraph(quadGraphNode);
    }

    @Override
    public Iterator<Quad> find(Node g2, Node s2, Node p, Node o) {
        if (DatasetGraphOne.isWildcard(g2) || DatasetGraphOne.isDefaultGraph(g2)) {
            return G.triples2quadsDftGraph(this.graph.find(s2, p, o));
        }
        return new NullIterator<Quad>();
    }

    @Override
    public void close() {
        this.graph.close();
        super.close();
    }
}

