/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.serializer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryVisitor;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.path.PathWriter;
import org.apache.jena.sparql.serializer.FmtEltLib;
import org.apache.jena.sparql.serializer.FmtExprSPARQL;
import org.apache.jena.sparql.serializer.FormatterBase;
import org.apache.jena.sparql.serializer.QuerySerializer;
import org.apache.jena.sparql.serializer.QuerySerializerFactory;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.serializer.SerializerRegistry;
import org.apache.jena.sparql.serializer.TriplesListBlock;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.Element1;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementDataset;
import org.apache.jena.sparql.syntax.ElementExists;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementFind;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementNotExists;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.vocabulary.RDF;

public class FormatterElement
extends FormatterBase
implements ElementVisitor {
    public static final int INDENT = 2;
    public static final boolean PATTERN_MARKERS = false;
    public static final boolean GROUP_SEP_DOT = false;
    public static final boolean GROUP_FIRST_ON_SAME_LINE = true;
    public static final boolean PRETTY_PRINT = true;
    public static final boolean FMT_LISTS = true;
    public static final boolean FMT_FREE_STANDING_LISTS = false;
    public static final boolean UNION_MARKERS = false;
    public static final boolean GRAPH_FIXED_INDENT = true;
    public static final boolean ELEMENT1_FIXED_INDENT = true;
    public static final int TRIPLES_SUBJECT_COLUMN = 8;
    public static final int TRIPLES_SUBJECT_LONG = 12;
    public static final int TRIPLES_PROPERTY_COLUMN = 20;
    public static final int TRIPLES_COLUMN_GAP = 2;
    int subjectWidth = -1;
    int predicateWidth = -1;
    private static String RDFTYPE = FmtUtils.stringForNode(RDF.Nodes.type, new SerializationContext());

    public FormatterElement(IndentedWriter out, SerializationContext context2) {
        super(out, context2);
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Element el) {
        FormatterElement fmt = new FormatterElement(out, cxt);
        fmt.startVisit();
        el.visit(fmt);
        fmt.finishVisit();
    }

    public static String asString(Element el) {
        SerializationContext cxt = new SerializationContext();
        IndentedLineBuffer b = new IndentedLineBuffer();
        FormatterElement.format(b, cxt, el);
        return b.toString();
    }

    public boolean topMustBeGroup() {
        return false;
    }

    @Override
    public void visit(ElementTriplesBlock el) {
        if (el.isEmpty()) {
            this.out.println("# Empty BGP");
            return;
        }
        this.formatTriples(el.getPattern());
    }

    @Override
    public void visit(ElementPathBlock el) {
        if (el.isEmpty()) {
            this.out.println("# Empty BGP");
            return;
        }
        PathBlock pBlk = el.getPattern();
        BasicPattern bgp = new BasicPattern();
        boolean first = true;
        for (TriplePath tp : pBlk) {
            if (tp.isTriple()) {
                bgp.add(tp.asTriple());
                continue;
            }
            if (!bgp.isEmpty()) {
                if (!first) {
                    this.out.println(" .");
                }
                this.flush(bgp);
                first = false;
            }
            if (!first) {
                this.out.println(" .");
            }
            this.printSubject(tp.getSubject());
            this.out.print(" ");
            PathWriter.write(this.out, tp.getPath(), this.context.getPrologue());
            this.out.print(" ");
            this.printObject(tp.getObject());
            first = false;
        }
        if (!bgp.isEmpty()) {
            if (!first) {
                this.out.println(" .");
            }
            this.flush(bgp);
            first = false;
        }
    }

    @Override
    public void visit(ElementDataset el) {
    }

    @Override
    public void visit(ElementFilter el) {
        this.out.print("FILTER ");
        Expr expr = el.getExpr();
        FmtExprSPARQL v = new FmtExprSPARQL(this.out, this.context);
        boolean addParens = false;
        if (expr.isVariable()) {
            addParens = true;
        }
        if (expr.isConstant()) {
            addParens = true;
        }
        if (addParens) {
            this.out.print("( ");
        }
        v.format(expr);
        if (addParens) {
            this.out.print(" )");
        }
    }

    @Override
    public void visit(ElementAssign el) {
        this.out.print("LET (");
        this.out.print("?" + el.getVar().getVarName());
        this.out.print(" := ");
        FmtExprSPARQL v = new FmtExprSPARQL(this.out, this.context);
        v.format(el.getExpr());
        this.out.print(")");
    }

    @Override
    public void visit(ElementBind el) {
        this.out.print("BIND(");
        FmtExprSPARQL v = new FmtExprSPARQL(this.out, this.context);
        v.format(el.getExpr());
        this.out.print(" AS ");
        this.out.print("?" + el.getVar().getVarName());
        this.out.print(")");
    }

    @Override
    public void visit(ElementFind el) {
        this.out.print("FIND(");
        this.out.print("<< ");
        this.formatTriple(el.getTriple());
        this.out.print(" >>");
        this.out.print(" AS ");
        this.out.print("?" + el.getVar().getVarName());
        this.out.print(")");
    }

    @Override
    public void visit(ElementData el) {
        QuerySerializer.outputDataBlock(this.out, el.getVars(), el.getRows(), this.context);
    }

    @Override
    public void visit(ElementUnion el) {
        if (el.getElements().size() == 0) {
            return;
        }
        if (el.getElements().size() == 0) {
            this.visitAsGroup(el.getElements().get(0));
            return;
        }
        this.out.incIndent(2);
        boolean first = true;
        for (Element subElement : el.getElements()) {
            if (!first) {
                this.out.decIndent(2);
                this.out.newline();
                this.out.print("UNION");
                this.out.newline();
                this.out.incIndent(2);
            }
            this.visitAsGroup(subElement);
            first = false;
        }
        this.out.decIndent(2);
    }

    @Override
    public void visit(ElementGroup el) {
        this.out.print("{");
        int initialRowNumber = this.out.getRow();
        this.out.incIndent(2);
        int row1 = this.out.getRow();
        this.out.pad();
        boolean first = true;
        Element lastElt = null;
        for (Element subElement : el.getElements()) {
            if (!first) {
                if (FormatterElement.needsDotSeparator(lastElt, subElement)) {
                    this.out.print(" . ");
                }
                this.out.newline();
            }
            subElement.visit(this);
            first = false;
            lastElt = subElement;
        }
        this.out.decIndent(2);
        int row2 = this.out.getRow();
        if (row1 != row2) {
            this.out.newline();
        }
        if (this.out.getRow() == initialRowNumber) {
            this.out.print(" ");
        }
        this.out.print("}");
    }

    private static boolean needsDotSeparator(Element el1, Element el2) {
        return FormatterElement.needsDotSeparator(el1) && FormatterElement.needsDotSeparator(el2);
    }

    private static boolean needsDotSeparator(Element el) {
        return el instanceof ElementTriplesBlock || el instanceof ElementPathBlock;
    }

    @Override
    public void visit(ElementOptional el) {
        this.out.print("OPTIONAL");
        this.out.incIndent(2);
        this.out.newline();
        this.visitAsGroup(el.getOptionalElement());
        this.out.decIndent(2);
    }

    @Override
    public void visit(ElementNamedGraph el) {
        this.visitNodePattern("GRAPH", el.getGraphNameNode(), el.getElement());
    }

    @Override
    public void visit(ElementService el) {
        String x = "SERVICE";
        if (el.getSilent()) {
            x = "SERVICE SILENT";
        }
        this.visitNodePattern(x, el.getServiceNode(), el.getElement());
    }

    private void visitNodePattern(String label, Node node, Element subElement) {
        int len = label.length();
        this.out.print(label);
        this.out.print(" ");
        String nodeStr = node == null ? "*" : this.slotToString(node);
        this.out.print(nodeStr);
        len += nodeStr.length();
        this.out.incIndent(2);
        this.out.newline();
        this.visitAsGroup(subElement);
        this.out.decIndent(2);
    }

    private void visitElement1(String label, Element1 el) {
        int len = label.length();
        this.out.print(label);
        len += label.length();
        this.out.incIndent(2);
        this.out.newline();
        this.visitAsGroup(el.getElement());
        this.out.decIndent(2);
    }

    @Override
    public void visit(ElementExists el) {
        this.visitElement1("EXISTS", el);
    }

    @Override
    public void visit(ElementNotExists el) {
        this.visitElement1("NOT EXISTS", el);
    }

    @Override
    public void visit(ElementMinus el) {
        this.out.print("MINUS");
        this.out.incIndent(2);
        this.out.newline();
        this.visitAsGroup(el.getMinusElement());
        this.out.decIndent(2);
    }

    @Override
    public void visit(ElementSubQuery el) {
        this.out.print("{ ");
        this.out.incIndent(2);
        Query q = el.getQuery();
        QuerySerializerFactory factory = SerializerRegistry.get().getQuerySerializerFactory(Syntax.syntaxARQ);
        QueryVisitor serializer = factory.create(Syntax.syntaxARQ, this.context, this.out);
        q.visit(serializer);
        this.out.decIndent(2);
        this.out.print("}");
    }

    public void visitAsGroup(Element el) {
        boolean needBraces;
        boolean bl = needBraces = !(el instanceof ElementGroup) && !(el instanceof ElementSubQuery);
        if (needBraces) {
            this.out.print("{ ");
            this.out.incIndent(2);
        }
        el.visit(this);
        if (needBraces) {
            this.out.decIndent(2);
            this.out.print("}");
        }
    }

    @Override
    protected void formatTriples(BasicPattern triples) {
        if (triples.isEmpty()) {
            return;
        }
        TriplesListBlock block = FmtEltLib.createTriplesListBlock(triples);
        HashSet<Node> freeStanding = new HashSet<Node>();
        for (Node head : block.listElementsMap.keySet()) {
            int inCount = FmtEltLib.count(triples.getList(), Node.ANY, Node.ANY, head);
            int outCount = FmtEltLib.count(triples.getList(), head, Node.ANY, Node.ANY);
            if (inCount != 0 || outCount != 2) continue;
            freeStanding.add(head);
        }
        this.setWidths(triples);
        if (this.subjectWidth > 8) {
            this.subjectWidth = 8;
        }
        if (this.predicateWidth > 20) {
            this.predicateWidth = 20;
        }
        ArrayList<Triple> subjAcc = new ArrayList<Triple>();
        Node subj = null;
        boolean first = true;
        int indent = -1;
        for (Triple t : triples) {
            if (block.triplesInLists.contains(t)) {
                if (!FmtEltLib.rdfFirst.equals(t.getPredicate()) || !freeStanding.contains(t.getSubject())) continue;
                this.printNodeOrList(t.getSubject(), block.listElementsMap);
                continue;
            }
            if (subj != null && t.getSubject().equals(subj)) {
                subjAcc.add(t);
                continue;
            }
            if (subj != null) {
                if (!first) {
                    this.out.println(" .");
                }
                this.formatSameSubject(subj, subjAcc, block.listElementsMap);
                first = false;
            }
            subj = t.getSubject();
            subjAcc.clear();
            subjAcc.add(t);
        }
        if (subj != null && subjAcc.size() != 0) {
            if (!first) {
                this.out.println(" .");
            }
            first = false;
            this.formatSameSubject(subj, subjAcc, block.listElementsMap);
        }
    }

    private void flush(BasicPattern bgp) {
        this.formatTriples(bgp);
        bgp.getList().clear();
    }

    private void formatSameSubject(Node subject, List<Triple> triples, Map<Node, List<Node>> lists) {
        if (triples == null || triples.size() == 0) {
            return;
        }
        Iterator<Triple> iter = triples.iterator();
        Triple t1 = iter.next();
        int indent = this.subjectWidth + 2;
        int s1_len = this.printNodeOrList(subject, lists);
        if (s1_len > 12) {
            this.out.incIndent(indent);
            this.out.println();
        } else {
            this.printGap();
            this.out.incIndent(indent);
        }
        this.printProperty(t1.getPredicate());
        this.printGap();
        this.printNodeOrList(t1.getObject(), lists);
        while (iter.hasNext()) {
            Triple t = iter.next();
            this.out.println(" ;");
            this.printProperty(t.getPredicate());
            this.printGap();
            this.printNodeOrList(t.getObject(), lists);
        }
        this.out.decIndent(indent);
    }

    private int printNodeOrList(Node node, Map<Node, List<Node>> lists) {
        if (lists.containsKey(node)) {
            return this.printList(lists.get(node), lists);
        }
        return this.printNoCol(node);
    }

    private void setWidths(BasicPattern triples) {
        this.subjectWidth = -1;
        this.predicateWidth = -1;
        for (Triple t : triples) {
            String p;
            String s2 = this.slotToString(t.getSubject());
            if (s2.length() > this.subjectWidth) {
                this.subjectWidth = s2.length();
            }
            if ((p = this.slotToStringProperty(t.getPredicate())).length() <= this.predicateWidth) continue;
            this.predicateWidth = p.length();
        }
    }

    private void printGap() {
        this.out.print(' ', 2);
    }

    private int printSubject(Node s2) {
        return this.printNoCol(s2);
    }

    private int printProperty(Node p) {
        String str2 = this.slotToStringProperty(p);
        this.out.print(str2);
        this.out.pad(this.predicateWidth);
        return this.out.getCol();
    }

    private String slotToStringProperty(Node p) {
        String str2 = this.slotToString(p);
        if (str2.equals(RDFTYPE)) {
            return "a";
        }
        return str2;
    }

    private int printObject(Node obj) {
        return this.printNoCol(obj);
    }

    private int printList(List<Node> list, Map<Node, List<Node>> lists) {
        if (list.isEmpty()) {
            this.out.print("()");
            return 2;
        }
        int col0 = this.out.getCol();
        this.out.print("( ");
        for (Node n : list) {
            this.printNodeOrList(n, lists);
            this.out.print(" ");
        }
        this.out.print(")");
        int col1 = this.out.getCol();
        return col1 - col0;
    }

    private int printNoCol(Node node) {
        String str2 = this.slotToString(node);
        this.out.print(str2);
        return str2.length();
    }
}

