/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;

public final class TermContext {
    private final Object topReaderContextIdentity;
    private final TermState[] states;
    private int docFreq;
    private long totalTermFreq;

    public TermContext(IndexReaderContext context2) {
        assert (context2 != null && context2.isTopLevel);
        this.topReaderContextIdentity = context2.identity;
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        int len = context2.leaves() == null ? 1 : context2.leaves().size();
        this.states = new TermState[len];
    }

    public boolean wasBuiltFor(IndexReaderContext context2) {
        return this.topReaderContextIdentity == context2.identity;
    }

    public TermContext(IndexReaderContext context2, TermState state, int ord, int docFreq, long totalTermFreq) {
        this(context2);
        this.register(state, ord, docFreq, totalTermFreq);
    }

    public static TermContext build(IndexReaderContext context2, Term term) throws IOException {
        assert (context2 != null && context2.isTopLevel);
        String field = term.field();
        BytesRef bytes = term.bytes();
        TermContext perReaderTermState = new TermContext(context2);
        for (LeafReaderContext ctx : context2.leaves()) {
            TermsEnum termsEnum;
            Terms terms = ctx.reader().terms(field);
            if (terms == null || !(termsEnum = terms.iterator()).seekExact(bytes)) continue;
            TermState termState = termsEnum.termState();
            perReaderTermState.register(termState, ctx.ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
        }
        return perReaderTermState;
    }

    public void clear() {
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        Arrays.fill(this.states, null);
    }

    public void register(TermState state, int ord, int docFreq, long totalTermFreq) {
        this.register(state, ord);
        this.accumulateStatistics(docFreq, totalTermFreq);
    }

    public void register(TermState state, int ord) {
        assert (state != null) : "state must not be null";
        assert (ord >= 0 && ord < this.states.length);
        assert (this.states[ord] == null) : "state for ord: " + ord + " already registered";
        this.states[ord] = state;
    }

    public void accumulateStatistics(int docFreq, long totalTermFreq) {
        this.docFreq += docFreq;
        this.totalTermFreq = this.totalTermFreq >= 0L && totalTermFreq >= 0L ? (this.totalTermFreq += totalTermFreq) : -1L;
    }

    public TermState get(int ord) {
        assert (ord >= 0 && ord < this.states.length);
        return this.states[ord];
    }

    public int docFreq() {
        return this.docFreq;
    }

    public long totalTermFreq() {
        return this.totalTermFreq;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TermContext\n");
        for (TermState termState : this.states) {
            sb.append("  state=");
            sb.append(termState.toString());
            sb.append('\n');
        }
        return sb.toString();
    }
}

