/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.ocfl.exception;

import java.util.List;
import java.util.Objects;

public class ChecksumMismatchException
extends RuntimeException {
    private final List<String> problems;
    private String message;

    public ChecksumMismatchException(List<String> problems) {
        this.problems = Objects.requireNonNull(problems, "problems cannot be null");
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            StringBuilder builder = new StringBuilder("The following checksums did not match: ");
            int index = 1;
            for (String problem : this.problems) {
                builder.append("\n  ").append(index++).append(". ");
                builder.append(problem);
            }
            this.message = builder.toString();
        }
        return this.message;
    }

    public List<String> getProblems() {
        return this.problems;
    }
}

