/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.ClassInfo;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.CollectionUtils;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.Local;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.ObjectSwitchCallback;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.Transformer;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.proxy.CallbackGenerator;

class MethodInterceptorGenerator
implements CallbackGenerator {
    public static final MethodInterceptorGenerator INSTANCE = new MethodInterceptorGenerator();
    static final String EMPTY_ARGS_NAME = "CGLIB$emptyArgs";
    static final String FIND_PROXY_NAME = "CGLIB$findMethodProxy";
    static final Class[] FIND_PROXY_TYPES = new Class[]{Signature.class};
    private static final Type ABSTRACT_METHOD_ERROR = TypeUtils.parseType("AbstractMethodError");
    private static final Type METHOD = TypeUtils.parseType("java.lang.reflect.Method");
    private static final Type REFLECT_UTILS = TypeUtils.parseType("org.springframework.cglib.core.ReflectUtils");
    private static final Type METHOD_PROXY = TypeUtils.parseType("org.springframework.cglib.proxy.MethodProxy");
    private static final Type METHOD_INTERCEPTOR = TypeUtils.parseType("org.springframework.cglib.proxy.MethodInterceptor");
    private static final Signature GET_DECLARED_METHODS = TypeUtils.parseSignature("java.lang.reflect.Method[] getDeclaredMethods()");
    private static final Signature GET_DECLARING_CLASS = TypeUtils.parseSignature("Class getDeclaringClass()");
    private static final Signature FIND_METHODS = TypeUtils.parseSignature("java.lang.reflect.Method[] findMethods(String[], java.lang.reflect.Method[])");
    private static final Signature MAKE_PROXY = new Signature("create", METHOD_PROXY, new Type[]{Constants.TYPE_CLASS, Constants.TYPE_CLASS, Constants.TYPE_STRING, Constants.TYPE_STRING, Constants.TYPE_STRING});
    private static final Signature INTERCEPT = new Signature("intercept", Constants.TYPE_OBJECT, new Type[]{Constants.TYPE_OBJECT, METHOD, Constants.TYPE_OBJECT_ARRAY, METHOD_PROXY});
    private static final Signature FIND_PROXY = new Signature("CGLIB$findMethodProxy", METHOD_PROXY, new Type[]{Constants.TYPE_SIGNATURE});
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    private static final Transformer METHOD_TO_CLASS = new Transformer(){

        public Object transform(Object value) {
            return ((MethodInfo)value).getClassInfo();
        }
    };
    private static final Signature CSTRUCT_SIGNATURE = TypeUtils.parseConstructor("String, String");

    MethodInterceptorGenerator() {
    }

    private String getMethodField(Signature impl) {
        return impl.getName() + "$Method";
    }

    private String getMethodProxyField(Signature impl) {
        return impl.getName() + "$Proxy";
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context2, List methods) {
        HashMap<String, String> sigMap = new HashMap<String, String>();
        for (MethodInfo method : methods) {
            Signature sig = method.getSignature();
            Signature impl = context2.getImplSignature(method);
            String methodField = this.getMethodField(impl);
            String methodProxyField = this.getMethodProxyField(impl);
            sigMap.put(sig.toString(), methodProxyField);
            ce.declare_field(26, methodField, METHOD, null);
            ce.declare_field(26, methodProxyField, METHOD_PROXY, null);
            ce.declare_field(26, EMPTY_ARGS_NAME, Constants.TYPE_OBJECT_ARRAY, null);
            CodeEmitter e2 = ce.begin_method(16, impl, method.getExceptionTypes());
            MethodInterceptorGenerator.superHelper(e2, method, context2);
            e2.return_value();
            e2.end_method();
            e2 = context2.beginMethod(ce, method);
            Label nullInterceptor = e2.make_label();
            context2.emitCallback(e2, context2.getIndex(method));
            e2.dup();
            e2.ifnull(nullInterceptor);
            e2.load_this();
            e2.getfield(methodField);
            if (sig.getArgumentTypes().length == 0) {
                e2.getfield(EMPTY_ARGS_NAME);
            } else {
                e2.create_arg_array();
            }
            e2.getfield(methodProxyField);
            e2.invoke_interface(METHOD_INTERCEPTOR, INTERCEPT);
            e2.unbox_or_zero(sig.getReturnType());
            e2.return_value();
            e2.mark(nullInterceptor);
            MethodInterceptorGenerator.superHelper(e2, method, context2);
            e2.return_value();
            e2.end_method();
        }
        this.generateFindProxy(ce, sigMap);
    }

    private static void superHelper(CodeEmitter e2, MethodInfo method, CallbackGenerator.Context context2) {
        if (TypeUtils.isAbstract(method.getModifiers())) {
            e2.throw_exception(ABSTRACT_METHOD_ERROR, method.toString() + " is abstract");
        } else {
            e2.load_this();
            context2.emitLoadArgsAndInvoke(e2, method);
        }
    }

    public void generateStatic(CodeEmitter e2, CallbackGenerator.Context context2, List methods) throws Exception {
        e2.push(0);
        e2.newarray();
        e2.putfield(EMPTY_ARGS_NAME);
        Local thisclass = e2.make_local();
        Local declaringclass = e2.make_local();
        EmitUtils.load_class_this(e2);
        e2.store_local(thisclass);
        Map methodsByClass = CollectionUtils.bucket(methods, METHOD_TO_CLASS);
        for (ClassInfo classInfo : methodsByClass.keySet()) {
            Signature sig;
            MethodInfo method;
            int index;
            List classMethods = (List)methodsByClass.get(classInfo);
            e2.push(2 * classMethods.size());
            e2.newarray(Constants.TYPE_STRING);
            for (index = 0; index < classMethods.size(); ++index) {
                method = (MethodInfo)classMethods.get(index);
                sig = method.getSignature();
                e2.dup();
                e2.push(2 * index);
                e2.push(sig.getName());
                e2.aastore();
                e2.dup();
                e2.push(2 * index + 1);
                e2.push(sig.getDescriptor());
                e2.aastore();
            }
            EmitUtils.load_class(e2, classInfo.getType());
            e2.dup();
            e2.store_local(declaringclass);
            e2.invoke_virtual(Constants.TYPE_CLASS, GET_DECLARED_METHODS);
            e2.invoke_static(REFLECT_UTILS, FIND_METHODS);
            for (index = 0; index < classMethods.size(); ++index) {
                method = (MethodInfo)classMethods.get(index);
                sig = method.getSignature();
                Signature impl = context2.getImplSignature(method);
                e2.dup();
                e2.push(index);
                e2.array_load(METHOD);
                e2.putfield(this.getMethodField(impl));
                e2.load_local(declaringclass);
                e2.load_local(thisclass);
                e2.push(sig.getDescriptor());
                e2.push(sig.getName());
                e2.push(impl.getName());
                e2.invoke_static(METHOD_PROXY, MAKE_PROXY);
                e2.putfield(this.getMethodProxyField(impl));
            }
            e2.pop();
        }
    }

    public void generateFindProxy(ClassEmitter ce, final Map sigMap) {
        final CodeEmitter e2 = ce.begin_method(9, FIND_PROXY, null);
        e2.load_arg(0);
        e2.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
        ObjectSwitchCallback callback = new ObjectSwitchCallback(){

            public void processCase(Object key, Label end) {
                e2.getfield((String)sigMap.get(key));
                e2.return_value();
            }

            public void processDefault() {
                e2.aconst_null();
                e2.return_value();
            }
        };
        EmitUtils.string_switch(e2, sigMap.keySet().toArray(new String[0]), 1, callback);
        e2.end_method();
    }
}

