/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.common;

import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.TypedValue;
import org.springframework.expression.common.ExpressionUtils;
import org.springframework.lang.Nullable;

public class LiteralExpression
implements Expression {
    private final String literalValue;

    public LiteralExpression(String literalValue) {
        this.literalValue = literalValue;
    }

    @Override
    public final String getExpressionString() {
        return this.literalValue;
    }

    @Override
    public Class<?> getValueType(EvaluationContext context2) {
        return String.class;
    }

    @Override
    public String getValue() {
        return this.literalValue;
    }

    @Override
    @Nullable
    public <T> T getValue(@Nullable Class<T> expectedResultType) throws EvaluationException {
        String value = this.getValue();
        return ExpressionUtils.convertTypedValue(null, new TypedValue(value), expectedResultType);
    }

    @Override
    public String getValue(@Nullable Object rootObject) {
        return this.literalValue;
    }

    @Override
    @Nullable
    public <T> T getValue(@Nullable Object rootObject, @Nullable Class<T> desiredResultType) throws EvaluationException {
        String value = this.getValue(rootObject);
        return ExpressionUtils.convertTypedValue(null, new TypedValue(value), desiredResultType);
    }

    @Override
    public String getValue(EvaluationContext context2) {
        return this.literalValue;
    }

    @Override
    @Nullable
    public <T> T getValue(EvaluationContext context2, @Nullable Class<T> expectedResultType) throws EvaluationException {
        String value = this.getValue(context2);
        return ExpressionUtils.convertTypedValue(context2, new TypedValue(value), expectedResultType);
    }

    @Override
    public String getValue(EvaluationContext context2, @Nullable Object rootObject) throws EvaluationException {
        return this.literalValue;
    }

    @Override
    @Nullable
    public <T> T getValue(EvaluationContext context2, @Nullable Object rootObject, @Nullable Class<T> desiredResultType) throws EvaluationException {
        String value = this.getValue(context2, rootObject);
        return ExpressionUtils.convertTypedValue(context2, new TypedValue(value), desiredResultType);
    }

    @Override
    public Class<?> getValueType() {
        return String.class;
    }

    @Override
    public Class<?> getValueType(@Nullable Object rootObject) throws EvaluationException {
        return String.class;
    }

    @Override
    public Class<?> getValueType(EvaluationContext context2, @Nullable Object rootObject) throws EvaluationException {
        return String.class;
    }

    @Override
    public TypeDescriptor getValueTypeDescriptor() {
        return TypeDescriptor.valueOf(String.class);
    }

    @Override
    public TypeDescriptor getValueTypeDescriptor(@Nullable Object rootObject) throws EvaluationException {
        return TypeDescriptor.valueOf(String.class);
    }

    @Override
    public TypeDescriptor getValueTypeDescriptor(EvaluationContext context2) {
        return TypeDescriptor.valueOf(String.class);
    }

    @Override
    public TypeDescriptor getValueTypeDescriptor(EvaluationContext context2, @Nullable Object rootObject) throws EvaluationException {
        return TypeDescriptor.valueOf(String.class);
    }

    @Override
    public boolean isWritable(@Nullable Object rootObject) throws EvaluationException {
        return false;
    }

    @Override
    public boolean isWritable(EvaluationContext context2) {
        return false;
    }

    @Override
    public boolean isWritable(EvaluationContext context2, @Nullable Object rootObject) throws EvaluationException {
        return false;
    }

    @Override
    public void setValue(@Nullable Object rootObject, @Nullable Object value) throws EvaluationException {
        throw new EvaluationException(this.literalValue, "Cannot call setValue() on a LiteralExpression");
    }

    @Override
    public void setValue(EvaluationContext context2, @Nullable Object value) throws EvaluationException {
        throw new EvaluationException(this.literalValue, "Cannot call setValue() on a LiteralExpression");
    }

    @Override
    public void setValue(EvaluationContext context2, @Nullable Object rootObject, @Nullable Object value) throws EvaluationException {
        throw new EvaluationException(this.literalValue, "Cannot call setValue() on a LiteralExpression");
    }
}

