/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers.ocfl;

import at.favre.lib.bytes.Bytes;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.fcrepo.migration.ContentDigest;
import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.FedoraObjectVersionHandler;
import org.fcrepo.migration.MigrationType;
import org.fcrepo.migration.ObjectInfo;
import org.fcrepo.migration.ObjectVersionReference;
import org.fcrepo.migration.handlers.ocfl.OcflObjectSessionWrapper;
import org.fcrepo.storage.ocfl.InteractionModel;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveGroupHandler
implements FedoraObjectVersionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveGroupHandler.class);
    private static final String FCREPO_ROOT = "info:fedora/";
    private static final Map<String, String> externalHandlingMap = Map.of("E", "proxy", "R", "redirect");
    private static final String INLINE_XML = "X";
    private static final String DS_INACTIVE = "I";
    private static final String DS_DELETED = "D";
    private static final String OBJ_STATE_PROP = "info:fedora/fedora-system:def/model#state";
    private static final String OBJ_INACTIVE = "Inactive";
    private static final String OBJ_DELETED = "Deleted";
    private final OcflObjectSessionFactory sessionFactory;
    private final boolean addDatastreamExtensions;
    private final boolean deleteInactive;
    private final boolean foxmlFile;
    private final MigrationType migrationType;
    private final String user;
    private final String idPrefix;
    private final Detector mimeDetector;
    private final boolean disableChecksumValidation;

    public ArchiveGroupHandler(OcflObjectSessionFactory sessionFactory, MigrationType migrationType, boolean addDatastreamExtensions, boolean deleteInactive, boolean foxmlFile, String user, String idPrefix, boolean disableChecksumValidation) {
        this.sessionFactory = (OcflObjectSessionFactory)Preconditions.checkNotNull((Object)sessionFactory, (Object)"sessionFactory cannot be null");
        this.migrationType = (MigrationType)((Object)Preconditions.checkNotNull((Object)((Object)migrationType), (Object)"migrationType cannot be null"));
        this.addDatastreamExtensions = addDatastreamExtensions;
        this.deleteInactive = deleteInactive;
        this.foxmlFile = foxmlFile;
        this.user = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)user), (Object)"user cannot be blank");
        this.idPrefix = idPrefix;
        this.disableChecksumValidation = disableChecksumValidation;
        try {
            this.mimeDetector = new TikaConfig().getDetector();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void processObjectVersions(Iterable<ObjectVersionReference> versions, ObjectInfo objectInfo) {
        String objectId = objectInfo.getPid();
        String f6ObjectId = this.idPrefix + objectId;
        HashMap<String, String> dsCreateDates = new HashMap<String, String>();
        String objectState = null;
        HashMap<String, String> datastreamStates = new HashMap<String, String>();
        for (ObjectVersionReference ov : versions) {
            OcflObjectSessionWrapper session;
            block25: {
                session = new OcflObjectSessionWrapper(this.sessionFactory.newSession(f6ObjectId));
                if (ov.isFirstVersion()) {
                    if (session.containsResource(f6ObjectId)) {
                        throw new RuntimeException(f6ObjectId + " already exists!");
                    }
                    objectState = this.getObjectState(ov, objectId);
                    if (this.foxmlFile) {
                        try (InputStream is = Files.newInputStream(objectInfo.getFoxmlPath(), new OpenOption[0]);){
                            String foxmlDsId = f6ObjectId + "/FOXML";
                            ResourceHeaders headers = this.createHeaders(foxmlDsId, f6ObjectId, InteractionModel.NON_RDF).build();
                            session.writeResource(headers, is);
                            datastreamStates.put(foxmlDsId, DS_DELETED);
                            break block25;
                        }
                        catch (IOException io) {
                            LOGGER.error("error writing " + objectId + " FOXML file to " + f6ObjectId + ": " + io);
                            throw new UncheckedIOException(io);
                        }
                    }
                    this.writeObjectFiles(objectId, f6ObjectId, ov, session);
                }
            }
            for (DatastreamVersion dv : ov.listChangedDatastreams()) {
                String mimeType = this.resolveMimeType(dv);
                String dsId = dv.getDatastreamInfo().getDatastreamId();
                String f6DsId = this.resolveF6DatastreamId(dsId, f6ObjectId, mimeType);
                String datastreamFilename = this.lastPartFromId(f6DsId);
                if (dv.isFirstVersionIn(ov.getObject())) {
                    dsCreateDates.put(dsId, dv.getCreated());
                    datastreamStates.put(f6DsId, dv.getDatastreamInfo().getState());
                }
                String createDate = (String)dsCreateDates.get(dsId);
                ResourceHeaders datastreamHeaders = this.createDatastreamHeaders(dv, f6DsId, f6ObjectId, datastreamFilename, mimeType, createDate);
                if (externalHandlingMap.containsKey(dv.getDatastreamInfo().getControlGroup())) {
                    InputStream content = null;
                    if (this.migrationType == MigrationType.PLAIN_OCFL) {
                        content = IOUtils.toInputStream((String)dv.getExternalOrRedirectURL());
                    }
                    session.writeResource(datastreamHeaders, content);
                } else {
                    try (InputStream contentStream = dv.getContent();){
                        this.writeDatastreamContent(dv, datastreamHeaders, contentStream, session);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                if (this.foxmlFile) continue;
                this.writeDescriptionFiles(f6DsId, datastreamFilename, createDate, datastreamHeaders, dv, session);
            }
            LOGGER.debug("Committing object <{}>", (Object)f6ObjectId);
            session.versionCreationTimestamp(OffsetDateTime.parse(ov.getVersionDate()));
            session.commit();
        }
        this.handleDeletedResources(f6ObjectId, objectState, datastreamStates);
    }

    private boolean fedora3DigestValid(ContentDigest f3Digest) {
        return f3Digest != null && StringUtils.isNotBlank((CharSequence)f3Digest.getType()) && StringUtils.isNotBlank((CharSequence)f3Digest.getDigest());
    }

    private void writeDatastreamContent(DatastreamVersion dv, ResourceHeaders datastreamHeaders, InputStream contentStream, OcflObjectSession session) throws IOException {
        block13: {
            if (this.disableChecksumValidation) {
                session.writeResource(datastreamHeaders, contentStream);
                return;
            }
            ContentDigest f3Digest = dv.getContentDigest();
            String ocflObjectId = session.ocflObjectId();
            String datastreamId = dv.getDatastreamInfo().getDatastreamId();
            String datastreamControlGroup = dv.getDatastreamInfo().getControlGroup();
            if (this.fedora3DigestValid(f3Digest)) {
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance(f3Digest.getType());
                    if (this.migrationType == MigrationType.PLAIN_OCFL) {
                        session.writeResource(datastreamHeaders, contentStream);
                        break block13;
                    }
                    try (DigestInputStream digestStream = new DigestInputStream(contentStream, messageDigest);){
                        session.writeResource(datastreamHeaders, (InputStream)digestStream);
                        String expectedDigest = f3Digest.getDigest();
                        String actualDigest = Bytes.wrap((byte[])digestStream.getMessageDigest().digest()).encodeHex();
                        if (!actualDigest.equalsIgnoreCase(expectedDigest)) {
                            String msg = String.format("%s/%s: digest %s doesn't match expected digest %s", ocflObjectId, datastreamId, actualDigest, expectedDigest);
                            throw new RuntimeException(msg);
                        }
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    String msg = String.format("%s/%s: no digest algorithm %s. Writing resource & continuing.", ocflObjectId, datastreamId, f3Digest.getType());
                    LOGGER.warn(msg);
                    session.writeResource(datastreamHeaders, contentStream);
                }
            } else {
                if (datastreamControlGroup.equalsIgnoreCase("M")) {
                    String msg = String.format("%s/%s: missing/invalid digest. Writing resource & continuing.", ocflObjectId, datastreamId);
                    LOGGER.warn(msg);
                }
                session.writeResource(datastreamHeaders, contentStream);
            }
        }
    }

    private void handleDeletedResources(String f6ObjectId, String objectState, Map<String, String> datastreamStates) {
        OcflObjectSessionWrapper session = new OcflObjectSessionWrapper(this.sessionFactory.newSession(f6ObjectId));
        try {
            OffsetDateTime now = OffsetDateTime.now().withOffsetSameInstant(ZoneOffset.UTC);
            AtomicBoolean hasDeletes = new AtomicBoolean(false);
            if (OBJ_DELETED.equals(objectState) || this.deleteInactive && OBJ_INACTIVE.equals(objectState)) {
                hasDeletes.set(true);
                datastreamStates.keySet().forEach(f6DsId -> this.deleteDatastream((String)f6DsId, now.toInstant(), session));
                if (this.migrationType == MigrationType.PLAIN_OCFL) {
                    this.deleteOcflMigratedResource(f6ObjectId, InteractionModel.BASIC_CONTAINER, session);
                } else {
                    this.deleteF6MigratedResource(f6ObjectId, now.toInstant(), session);
                }
            } else {
                datastreamStates.forEach((f6DsId, state) -> {
                    if (DS_DELETED.equals(state) || this.deleteInactive && DS_INACTIVE.equals(state)) {
                        hasDeletes.set(true);
                        this.deleteDatastream((String)f6DsId, now.toInstant(), session);
                    }
                });
            }
            if (hasDeletes.get()) {
                session.versionCreationTimestamp(now);
                session.commit();
            } else {
                session.abort();
            }
        }
        catch (RuntimeException e) {
            session.abort();
            throw e;
        }
    }

    private void writeObjectFiles(String pid, String f6ObjectId, ObjectVersionReference ov, OcflObjectSession session) {
        ResourceHeaders objectHeaders = this.createObjectHeaders(f6ObjectId, ov);
        InputStream content = ArchiveGroupHandler.getObjTriples(ov, pid);
        session.writeResource(objectHeaders, content);
    }

    private void writeDescriptionFiles(String f6Dsid, String datastreamFilename, String createDate, ResourceHeaders datastreamHeaders, DatastreamVersion dv, OcflObjectSession session) {
        ResourceHeaders descriptionHeaders = this.createDescriptionHeaders(f6Dsid, datastreamFilename, datastreamHeaders);
        session.writeResource(descriptionHeaders, this.getDsTriples(dv, f6Dsid, createDate));
    }

    private String f6DescriptionId(String f6ResourceId) {
        return f6ResourceId + "/fcr:metadata";
    }

    private String lastPartFromId(String id) {
        return id.substring(id.lastIndexOf(47) + 1);
    }

    private String resolveF6DatastreamId(String datastreamId, String f6ObjectId, String mimeType) {
        String id = f6ObjectId + "/" + datastreamId;
        if (this.addDatastreamExtensions && !Strings.isNullOrEmpty((String)mimeType)) {
            id = id + ArchiveGroupHandler.getExtension(mimeType);
        }
        return id;
    }

    private ResourceHeaders.Builder createHeaders(String id, String parentId, InteractionModel model) {
        ResourceHeaders.Builder headers = ResourceHeaders.builder();
        headers.withHeadersVersion("1.0");
        headers.withId(id);
        headers.withParent(parentId);
        headers.withInteractionModel(model.getUri());
        return headers;
    }

    private ResourceHeaders createObjectHeaders(String f6ObjectId, ObjectVersionReference ov) {
        ResourceHeaders.Builder headers = this.createHeaders(f6ObjectId, FCREPO_ROOT, InteractionModel.BASIC_CONTAINER);
        headers.withArchivalGroup(true);
        headers.withObjectRoot(true);
        headers.withLastModifiedBy(this.user);
        headers.withCreatedBy(this.user);
        ov.getObjectProperties().listProperties().forEach(p -> {
            if (p.getName().contains("lastModifiedDate")) {
                Instant lastModified = Instant.parse(p.getValue());
                headers.withLastModifiedDate(lastModified);
                headers.withMementoCreatedDate(lastModified);
                headers.withStateToken(DigestUtils.md5Hex((String)String.valueOf(lastModified.toEpochMilli())).toUpperCase());
            } else if (p.getName().contains("createdDate")) {
                headers.withCreatedDate(Instant.parse(p.getValue()));
            }
        });
        return headers.build();
    }

    private ResourceHeaders createDatastreamHeaders(DatastreamVersion dv, String f6DsId, String f6ObjectId, String filename, String mime, String createDate) {
        Instant lastModified = Instant.parse(dv.getCreated());
        ResourceHeaders.Builder headers = this.createHeaders(f6DsId, f6ObjectId, InteractionModel.NON_RDF);
        headers.withArchivalGroupId(f6ObjectId);
        headers.withFilename(filename);
        headers.withCreatedDate(Instant.parse(createDate));
        headers.withLastModifiedDate(lastModified);
        headers.withLastModifiedBy(this.user);
        headers.withCreatedBy(this.user);
        headers.withMementoCreatedDate(lastModified);
        if (externalHandlingMap.containsKey(dv.getDatastreamInfo().getControlGroup())) {
            headers.withExternalHandling(externalHandlingMap.get(dv.getDatastreamInfo().getControlGroup()));
            headers.withExternalUrl(dv.getExternalOrRedirectURL());
        }
        headers.withArchivalGroup(false);
        headers.withObjectRoot(false);
        if (dv.getSize() > -1L && !INLINE_XML.equals(dv.getDatastreamInfo().getControlGroup())) {
            headers.withContentSize(dv.getSize());
        }
        if (dv.getContentDigest() != null && !Strings.isNullOrEmpty((String)dv.getContentDigest().getDigest())) {
            ContentDigest digest = dv.getContentDigest();
            ArrayList<URI> digests = new ArrayList<URI>();
            digests.add(URI.create("urn:" + digest.getType().toLowerCase() + ":" + digest.getDigest().toLowerCase()));
            headers.withDigests(digests);
        }
        headers.withMimeType(mime);
        headers.withStateToken(DigestUtils.md5Hex((String)String.valueOf(lastModified.toEpochMilli())).toUpperCase());
        return headers.build();
    }

    private ResourceHeaders createDescriptionHeaders(String f6DsId, String filename, ResourceHeaders datastreamHeaders) {
        String id = this.f6DescriptionId(f6DsId);
        ResourceHeaders.Builder headers = this.createHeaders(id, f6DsId, InteractionModel.NON_RDF_DESCRIPTION);
        headers.withArchivalGroupId(datastreamHeaders.getArchivalGroupId());
        headers.withFilename(filename);
        headers.withCreatedDate(datastreamHeaders.getCreatedDate());
        headers.withLastModifiedDate(datastreamHeaders.getLastModifiedDate());
        headers.withCreatedBy(datastreamHeaders.getCreatedBy());
        headers.withLastModifiedBy(datastreamHeaders.getLastModifiedBy());
        headers.withMementoCreatedDate(datastreamHeaders.getMementoCreatedDate());
        headers.withArchivalGroup(false);
        headers.withObjectRoot(false);
        headers.withStateToken(datastreamHeaders.getStateToken());
        return headers.build();
    }

    private String resolveMimeType(DatastreamVersion dv) {
        String mime = dv.getMimeType();
        if (Strings.isNullOrEmpty((String)mime)) {
            Metadata meta = new Metadata();
            meta.set("resourceName", dv.getDatastreamInfo().getDatastreamId());
            try (TikaInputStream content = TikaInputStream.get((InputStream)dv.getContent());){
                mime = this.mimeDetector.detect((InputStream)content, meta).toString();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return mime;
    }

    private void deleteDatastream(String id, Instant lastModified, OcflObjectSession session) {
        if (this.migrationType == MigrationType.PLAIN_OCFL) {
            this.deleteOcflMigratedResource(id, InteractionModel.NON_RDF, session);
            this.deleteOcflMigratedResource(this.f6DescriptionId(id), InteractionModel.NON_RDF_DESCRIPTION, session);
        } else {
            this.deleteF6MigratedResource(id, lastModified, session);
            this.deleteF6MigratedResource(this.f6DescriptionId(id), lastModified, session);
        }
    }

    private void deleteF6MigratedResource(String id, Instant lastModified, OcflObjectSession session) {
        LOGGER.debug("Deleting resource {}", (Object)id);
        ResourceHeaders headers = session.readHeaders(id);
        session.deleteContentFile(ResourceHeaders.builder((ResourceHeaders)headers).withDeleted(true).withLastModifiedDate(lastModified).withMementoCreatedDate(lastModified).build());
    }

    private void deleteOcflMigratedResource(String id, InteractionModel interactionModel, OcflObjectSession session) {
        LOGGER.debug("Deleting resource {}", (Object)id);
        session.deleteContentFile(ResourceHeaders.builder().withId(id).withInteractionModel(interactionModel.getUri()).build());
    }

    private String getObjectState(ObjectVersionReference ov, String pid) {
        return ov.getObjectProperties().listProperties().stream().filter(prop -> OBJ_STATE_PROP.equals(prop.getName())).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Object %s is missing state information", pid))).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getObjTriples(ObjectVersionReference o, String pid) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (Model triples = ModelFactory.createDefaultModel();){
            String uri = FCREPO_ROOT + pid;
            o.getObjectProperties().listProperties().forEach(p -> {
                if (p.getName().contains("Date")) {
                    ArchiveGroupHandler.addDateLiteral(triples, uri, p.getName(), p.getValue());
                } else {
                    ArchiveGroupHandler.addStringLiteral(triples, uri, p.getName(), p.getValue());
                }
            });
            triples.write((OutputStream)out, "N-TRIPLES");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getDsTriples(DatastreamVersion dv, String f6DsId, String createDate) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (Model triples = ModelFactory.createDefaultModel();){
            if (this.migrationType == MigrationType.PLAIN_OCFL) {
                ArchiveGroupHandler.addDateLiteral(triples, f6DsId, "http://fedora.info/definitions/v4/repository#created", createDate);
                ArchiveGroupHandler.addDateLiteral(triples, f6DsId, "http://fedora.info/definitions/v4/repository#lastModified", dv.getCreated());
                ArchiveGroupHandler.addStringLiteral(triples, f6DsId, "http://purl.org/dc/terms/identifier", dv.getDatastreamInfo().getDatastreamId());
                ArchiveGroupHandler.addStringLiteral(triples, f6DsId, "http://www.ebu.ch/metadata/ontologies/ebucore/ebucore#hasMimeType", dv.getMimeType());
                ArchiveGroupHandler.addLongLiteral(triples, f6DsId, "http://www.loc.gov/premis/rdf/v1#size", dv.getSize());
                if (dv.getContentDigest() != null) {
                    ArchiveGroupHandler.addStringLiteral(triples, f6DsId, "http://www.loc.gov/premis/rdf/v1#hasMessageDigest", "urn:" + dv.getContentDigest().getType().toLowerCase() + ":" + dv.getContentDigest().getDigest().toLowerCase());
                }
            }
            ArchiveGroupHandler.addStringLiteral(triples, f6DsId, "http://purl.org/dc/terms/title", dv.getLabel());
            ArchiveGroupHandler.addStringLiteral(triples, f6DsId, "http://fedora.info/definitions/1/0/access/objState", dv.getDatastreamInfo().getState());
            ArchiveGroupHandler.addStringLiteral(triples, f6DsId, "http://www.loc.gov/premis/rdf/v1#formatDesignation", dv.getFormatUri());
            triples.write((OutputStream)out, "N-TRIPLES");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
    }

    private static void addStringLiteral(Model m, String s, String p, String o) {
        if (o != null) {
            m.add(m.createResource(s), m.createProperty(p), o);
        }
    }

    private static void addDateLiteral(Model m, String s, String p, String date) {
        if (date != null) {
            m.addLiteral(m.createResource(s), m.createProperty(p), m.createTypedLiteral(date, (RDFDatatype)XSDDatatype.XSDdateTime));
        }
    }

    private static void addLongLiteral(Model m, String s, String p, long number) {
        if (number != -1L) {
            m.addLiteral(m.createResource(s), m.createProperty(p), m.createTypedLiteral((Object)number, (RDFDatatype)XSDDatatype.XSDlong));
        }
    }

    private static String getExtension(String mime) {
        MimeType type;
        MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
        try {
            type = allTypes.forName(mime);
        }
        catch (MimeTypeException e) {
            type = null;
        }
        if (type != null) {
            return type.getExtension();
        }
        LOGGER.warn("No mimetype found for '{}'", (Object)mime);
        return "";
    }
}

