/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.turtle;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.n3.JenaURIException;
import com.hp.hpl.jena.n3.turtle.LabelToNodeMap;
import com.hp.hpl.jena.n3.turtle.TurtleEventHandler;
import com.hp.hpl.jena.n3.turtle.TurtleParseException;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.vocabulary.RDF;

public class ParserBase {
    protected final Node XSD_TRUE = NodeFactory.createLiteral("true", null, XSDDatatype.XSDboolean);
    protected final Node XSD_FALSE = NodeFactory.createLiteral("false", null, XSDDatatype.XSDboolean);
    protected final Node nRDFtype = RDF.type.asNode();
    protected final Node nRDFnil = RDF.nil.asNode();
    protected final Node nRDFfirst = RDF.first.asNode();
    protected final Node nRDFrest = RDF.rest.asNode();
    protected final Node nRDFsubject = RDF.subject.asNode();
    protected final Node nRDFpredicate = RDF.predicate.asNode();
    protected final Node nRDFobject = RDF.object.asNode();
    protected final String SWAP_NS = "http://www.w3.org/2000/10/swap/";
    protected final String SWAP_LOG_NS = "http://www.w3.org/2000/10/swap/log#";
    protected final Node nLogImplies = NodeFactory.createURI("http://www.w3.org/2000/10/swap/log#implies");
    protected final Node nOwlSameAs = NodeFactory.createURI("http://www.w3.org/2002/07/owl#sameAs");
    protected boolean strictTurtle = true;
    protected boolean skolomizedBNodes = true;
    PrefixMapping prefixMapping = new PrefixMappingImpl();
    IRIResolver resolver = new IRIResolver();
    LabelToNodeMap bNodeLabels = new LabelToNodeMap();
    TurtleEventHandler handler = null;
    static final String bNodeLabelStart = "_:";

    protected String getBaseURI() {
        return this.resolver.getBaseIRI();
    }

    public void setBaseURI(String u) {
        this.resolver = new IRIResolver(u);
    }

    protected void setBase(String iriStr, int line, int column) {
        this.setBaseURI(iriStr);
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMapping;
    }

    public void setEventHandler(TurtleEventHandler h2) {
        this.handler = h2;
    }

    protected void emitTriple(int line, int col, Triple triple) {
        this.handler.triple(line, col, triple);
    }

    protected void startFormula(int line, int col) {
        this.handler.startFormula(line, col);
    }

    protected void endFormula(int line, int col) {
        this.handler.endFormula(line, col);
    }

    protected void setPrefix(int line, int col, String prefix, String uri) {
        this.prefixMapping.setNsPrefix(prefix, uri);
        this.handler.prefix(line, col, prefix, uri);
    }

    protected int makePositiveInteger(String lexicalForm) {
        if (lexicalForm == null) {
            return -1;
        }
        return Integer.parseInt(lexicalForm);
    }

    protected Node createLiteralInteger(String lexicalForm) {
        return NodeFactory.createLiteral(lexicalForm, null, XSDDatatype.XSDinteger);
    }

    protected Node createLiteralDouble(String lexicalForm) {
        return NodeFactory.createLiteral(lexicalForm, null, XSDDatatype.XSDdouble);
    }

    protected Node createLiteralDecimal(String lexicalForm) {
        return NodeFactory.createLiteral(lexicalForm, null, XSDDatatype.XSDdecimal);
    }

    protected Node createLiteral(String lexicalForm, String langTag, Node datatype) {
        String uri = datatype == null ? null : datatype.getURI();
        return this.createLiteral(lexicalForm, langTag, uri);
    }

    protected Node createLiteral(String lexicalForm, String langTag, String datatypeURI) {
        Node n = null;
        if (datatypeURI != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
            n = NodeFactory.createLiteral(lexicalForm, null, dType);
        } else {
            n = NodeFactory.createLiteral(lexicalForm, langTag, null);
        }
        return n;
    }

    protected long integerValue(String s2) {
        if (s2.startsWith("+")) {
            s2 = s2.substring(1);
        }
        if (s2.startsWith("0x")) {
            s2 = s2.substring(2);
            return Long.parseLong(s2, 16);
        }
        return Long.parseLong(s2);
    }

    protected double doubleValue(String s2) {
        if (s2.startsWith("+")) {
            s2 = s2.substring(1);
        }
        double valDouble = Double.parseDouble(s2);
        return valDouble;
    }

    protected String stripQuotes(String s2) {
        return s2.substring(1, s2.length() - 1);
    }

    protected String stripQuotes3(String s2) {
        return s2.substring(3, s2.length() - 3);
    }

    protected String stripChars(String s2, int n) {
        return s2.substring(n, s2.length());
    }

    protected String resolveQuotedIRI(String iriStr, int line, int column) {
        iriStr = this.stripQuotes(iriStr);
        return this.resolveIRI(iriStr, line, column);
    }

    protected String resolveIRI(String iriStr, int line, int column) {
        if (this.isBNodeIRI(iriStr)) {
            return iriStr;
        }
        if (this.resolver != null) {
            iriStr = this._resolveIRI(iriStr, line, column);
        }
        return iriStr;
    }

    private String _resolveIRI(String iriStr, int line, int column) {
        try {
            iriStr = this.resolver.resolve(iriStr);
        }
        catch (JenaURIException ex) {
            this.throwParseException(ex.getMessage(), line, column);
        }
        return iriStr;
    }

    protected String resolvePName(String qname, int line, int column) {
        String s2 = ParserBase.myExpandPrefix(this.prefixMapping, qname);
        if (s2 == null) {
            this.throwParseException("Unresolved prefixed name: " + qname, line, column);
        }
        return s2;
    }

    private static String myExpandPrefix(PrefixMapping prefixMapping, String qname) {
        String s2 = prefixMapping.expandPrefix(qname);
        if (s2 == null) {
            return null;
        }
        if (s2.equals(qname)) {
            int colon = qname.indexOf(58);
            if (colon < 0) {
                return null;
            }
            String prefix = qname.substring(0, colon);
            if (prefixMapping.getNsPrefixURI(prefix) != null) {
                return s2;
            }
            return null;
        }
        return s2;
    }

    protected Node createListNode() {
        return this.createBNode();
    }

    protected Node createBNode() {
        return this.bNodeLabels.allocNode();
    }

    protected Node createBNode(String label, int line, int column) {
        return this.bNodeLabels.asNode(label);
    }

    protected Node createVariable(String s2, int line, int column) {
        s2 = s2.substring(1);
        return NodeFactory.createVariable(s2);
    }

    protected Node createNode(String iri2) {
        if (this.isBNodeIRI(iri2)) {
            String s2 = iri2.substring(bNodeLabelStart.length());
            Node n = NodeFactory.createAnon(new AnonId(s2));
            return n;
        }
        return NodeFactory.createURI(iri2);
    }

    protected boolean isBNodeIRI(String iri2) {
        return this.skolomizedBNodes && iri2.startsWith(bNodeLabelStart);
    }

    protected void throwParseException(String s2, int line, int column) {
        throw new TurtleParseException(ParserBase.exMsg(s2, line, column));
    }

    protected String fixupPrefix(String prefix, int line, int column) {
        if (prefix.endsWith(":")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    public static String unescapeStr(String s2) {
        return ParserBase.unescape(s2, '\\', false, 1, 1);
    }

    protected String unescapeStr(String s2, int line, int column) {
        return ParserBase.unescape(s2, '\\', false, line, column);
    }

    private static String unescape(String s2, char escape, boolean pointCodeOnly, int line, int column) {
        int i = s2.indexOf(escape);
        if (i == -1) {
            return s2;
        }
        StringBuilder sb = new StringBuilder(s2.substring(0, i));
        int len = s2.length();
        while (i < len) {
            char ch = s2.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    ++line;
                    column = 1;
                    break;
                }
                default: {
                    ++column;
                }
            }
            if (ch != escape) {
                sb.append(ch);
            } else {
                int x;
                if (i >= len - 1) {
                    throw new TurtleParseException(ParserBase.exMsg("Illegal escape at end of string", line, column));
                }
                char ch2 = s2.charAt(i + 1);
                ++column;
                ++i;
                if (ch2 == 'u') {
                    if (i + 4 >= len) {
                        throw new TurtleParseException(ParserBase.exMsg("\\u escape too short", line, column));
                    }
                    x = ParserBase.hex(s2, i + 1, 4, line, column);
                    sb.append((char)x);
                    i += 4;
                    column += 4;
                } else if (ch2 == 'U') {
                    if (i + 8 >= len) {
                        throw new TurtleParseException(ParserBase.exMsg("\\U escape too short", line, column));
                    }
                    x = ParserBase.hex(s2, i + 1, 8, line, column);
                    sb.append((char)x);
                    i += 8;
                    column += 8;
                } else if (pointCodeOnly) {
                    sb.append('\\');
                    sb.append(ch2);
                    ++i;
                } else {
                    char ch3 = '\u0000';
                    switch (ch2) {
                        case 'n': {
                            ch3 = '\n';
                            break;
                        }
                        case 't': {
                            ch3 = '\t';
                            break;
                        }
                        case 'r': {
                            ch3 = '\r';
                            break;
                        }
                        case 'b': {
                            ch3 = '\b';
                            break;
                        }
                        case 'f': {
                            ch3 = '\f';
                            break;
                        }
                        case '\'': {
                            ch3 = '\'';
                            break;
                        }
                        case '\"': {
                            ch3 = '\"';
                            break;
                        }
                        case '\\': {
                            ch3 = '\\';
                            break;
                        }
                        default: {
                            throw new TurtleParseException(ParserBase.exMsg("Unknown escape: \\" + ch2, line, column));
                        }
                    }
                    sb.append(ch3);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static int hex(String s2, int i, int len, int line, int column) {
        int x = 0;
        for (int j = i; j < i + len; ++j) {
            char ch = s2.charAt(j);
            ++column;
            int k = 0;
            switch (ch) {
                case '0': {
                    k = 0;
                    break;
                }
                case '1': {
                    k = 1;
                    break;
                }
                case '2': {
                    k = 2;
                    break;
                }
                case '3': {
                    k = 3;
                    break;
                }
                case '4': {
                    k = 4;
                    break;
                }
                case '5': {
                    k = 5;
                    break;
                }
                case '6': {
                    k = 6;
                    break;
                }
                case '7': {
                    k = 7;
                    break;
                }
                case '8': {
                    k = 8;
                    break;
                }
                case '9': {
                    k = 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    k = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    k = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    k = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    k = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    k = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    k = 15;
                    break;
                }
                default: {
                    throw new TurtleParseException(ParserBase.exMsg("Illegal hex escape: " + ch, line, column));
                }
            }
            x = (x << 4) + k;
        }
        return x;
    }

    protected static String exMsg(String msg, int line, int column) {
        return "Line " + line + ", column " + column + ": " + msg;
    }
}

