/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.OntPropertyImpl;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;

public class ObjectPropertyImpl
extends OntPropertyImpl
implements ObjectProperty {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new ObjectPropertyImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to ObjectProperty");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile2 = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile2 != null && profile2.isSupported(node, eg, ObjectProperty.class);
        }
    };

    public ObjectPropertyImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public OntProperty getInverseOf() {
        OntProperty inv = super.getInverseOf();
        return inv == null ? null : inv.asObjectProperty();
    }

    @Override
    public ExtendedIterator<? extends OntProperty> listInverseOf() {
        ArrayList<ObjectProperty> objPs = new ArrayList<ObjectProperty>();
        ExtendedIterator<? extends OntProperty> i = super.listInverseOf();
        while (i.hasNext()) {
            objPs.add(((OntProperty)i.next()).as(ObjectProperty.class));
        }
        return WrappedIterator.create(objPs.iterator());
    }

    @Override
    public OntProperty getInverse() {
        OntProperty inv = super.getInverse();
        return inv != null ? inv.asObjectProperty() : null;
    }
}

