/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import java.util.Iterator;
import java.util.List;

public class ModelListenerAdapter
implements GraphListener {
    protected ModelCom m;
    protected ModelChangedListener L;

    public ModelListenerAdapter(ModelCom m3, ModelChangedListener L) {
        this.m = m3;
        this.L = L;
    }

    @Override
    public void notifyAddArray(Graph graph, Triple[] triples) {
        this.L.addedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyDeleteArray(Graph g2, Triple[] triples) {
        this.L.removedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyAddTriple(Graph g2, Triple t) {
        this.L.addedStatement(this.m.asStatement(t));
    }

    @Override
    public void notifyAddList(Graph g2, List<Triple> triples) {
        this.L.addedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyAddIterator(Graph g2, Iterator<Triple> it) {
        this.L.addedStatements(this.m.asStatements(it));
    }

    @Override
    public void notifyAddGraph(Graph g2, Graph added) {
        this.L.addedStatements(this.m.asModel(added));
    }

    @Override
    public void notifyDeleteIterator(Graph g2, Iterator<Triple> it) {
        this.L.removedStatements(this.m.asStatements(it));
    }

    @Override
    public void notifyDeleteTriple(Graph g2, Triple t) {
        this.L.removedStatement(this.m.asStatement(t));
    }

    public void notifyAddIterator(Graph g2, List<Triple> triples) {
        this.L.addedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyDeleteList(Graph g2, List<Triple> triples) {
        this.L.removedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyDeleteGraph(Graph g2, Graph removed) {
        this.L.removedStatements(this.m.asModel(removed));
    }

    @Override
    public void notifyEvent(Graph g2, Object event) {
        this.L.notifyEvent(this.m, event);
    }

    public boolean equals(Object other) {
        return other instanceof ModelListenerAdapter && ((ModelListenerAdapter)other).sameAs(this);
    }

    public boolean sameAs(ModelListenerAdapter other) {
        return this.L.equals(other.L) && this.m.equals(other.m);
    }
}

