/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdfxml.xmlinput.states;

import com.hp.hpl.jena.rdfxml.xmlinput.impl.AbsXMLContext;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.XMLHandler;
import com.hp.hpl.jena.rdfxml.xmlinput.states.Frame;
import com.hp.hpl.jena.rdfxml.xmlinput.states.FrameI;
import com.hp.hpl.jena.rdfxml.xmlinput.states.InnerXMLLiteral;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public abstract class AbsXMLLiteral
extends Frame {
    boolean checkComposingChar = true;
    static Map<String, String> xmlNameSpace = new TreeMap<String, String>();
    protected final StringBuffer rslt;
    public final Map<String, String> namespaces;

    @Override
    String suggestParsetypeLiteral() {
        return "";
    }

    private static String prefix(String qname) {
        int colon = qname.indexOf(58);
        return colon == -1 ? "" : qname.substring(0, colon);
    }

    protected void append(String s2) {
        this.rslt.append(s2);
    }

    private void append(char[] ch, int s2, int l) {
        this.rslt.append(ch, s2, l);
    }

    protected void append(char s2) {
        this.rslt.append(s2);
    }

    public AbsXMLLiteral(FrameI p, AbsXMLContext x, StringBuffer r) {
        super(p, x);
        this.rslt = r;
        this.namespaces = xmlNameSpace;
    }

    public AbsXMLLiteral(AbsXMLLiteral p, Map<String, String> ns) {
        super((FrameI)p, p.xml);
        this.rslt = p.rslt;
        this.namespaces = ns;
    }

    public AbsXMLLiteral(XMLHandler h2, AbsXMLContext x) {
        super(h2, x);
        this.rslt = new StringBuffer();
        this.namespaces = xmlNameSpace;
    }

    private void useNameSpace(String prefix, String uri, Map<String, String> ns) {
        if (!uri.equals(this.namespaces.get(prefix))) {
            ns.put(prefix, uri);
        }
    }

    @Override
    public abstract void endElement() throws SAXParseException;

    void startLitElement(String uri, String rawName, Map<String, String> ns) {
        this.append('<');
        this.append(rawName);
        this.useNameSpace(AbsXMLLiteral.prefix(rawName), uri, ns);
    }

    private void appendAttrValue(String s2) {
        for (int i = 0; i < s2.length(); ++i) {
            String replace;
            char ch = s2.charAt(i);
            switch (ch) {
                case '&': {
                    replace = "&amp;";
                    break;
                }
                case '<': {
                    replace = "&lt;";
                    break;
                }
                case '\"': {
                    replace = "&quot;";
                    break;
                }
                case '\t': {
                    replace = "&#x9;";
                    break;
                }
                case '\n': {
                    replace = "&#xA;";
                    break;
                }
                case '\r': {
                    replace = "&#xD;";
                    break;
                }
                default: {
                    replace = null;
                }
            }
            if (replace != null) {
                this.append(replace);
                continue;
            }
            this.append(ch);
        }
    }

    @Override
    public void characters(char[] chrs, int start, int length) throws SAXParseException {
        if (this.checkComposingChar) {
            this.checkComposingChar(this.taint, chrs, start, length);
        }
        this.checkComposingChar = false;
        for (int i = 0; i < length; ++i) {
            String replace;
            char ch = chrs[start + i];
            switch (ch) {
                case '&': {
                    replace = "&amp;";
                    break;
                }
                case '<': {
                    replace = "&lt;";
                    break;
                }
                case '>': {
                    replace = "&gt;";
                    break;
                }
                case '\r': {
                    replace = "&#xD;";
                    break;
                }
                default: {
                    replace = null;
                }
            }
            if (replace != null) {
                this.append(replace);
                continue;
            }
            this.append(ch);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXParseException {
        this.append("<!--");
        this.append(ch, start, length);
        this.append("-->");
        this.checkComposingChar = true;
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.append("<?");
        this.append(target);
        this.append(' ');
        this.append(data);
        this.append("?>");
        this.checkComposingChar = true;
    }

    @Override
    public FrameI startElement(String uri, String localName, String rawName, Attributes atts) {
        String prefix;
        this.checkComposingChar = true;
        TreeMap<String, String> attrMap = new TreeMap<String, String>();
        Map<String, String> childNameSpaces = new TreeMap<String, String>();
        this.startLitElement(uri, rawName, childNameSpaces);
        for (int i = atts.getLength() - 1; i >= 0; --i) {
            String string = atts.getURI(i);
            String qname = atts.getQName(i);
            String prefix2 = AbsXMLLiteral.prefix(qname);
            if (!prefix2.equals("")) {
                this.useNameSpace(prefix2, string, childNameSpaces);
            }
            attrMap.put(qname, atts.getValue(i));
        }
        for (Map.Entry entry : childNameSpaces.entrySet()) {
            this.append(" xmlns");
            prefix = (String)entry.getKey();
            if (!"".equals(prefix)) {
                this.append(':');
                this.append(prefix);
            }
            this.append("=\"");
            this.appendAttrValue((String)entry.getValue());
            this.append('\"');
        }
        for (Map.Entry entry : attrMap.entrySet()) {
            this.append(' ');
            this.append((String)entry.getKey());
            this.append("=\"");
            this.appendAttrValue((String)entry.getValue());
            this.append('\"');
        }
        this.append('>');
        if (childNameSpaces.isEmpty()) {
            childNameSpaces = this.namespaces;
        } else {
            for (Map.Entry<Object, Object> entry : this.namespaces.entrySet()) {
                prefix = (String)entry.getKey();
                if (childNameSpaces.containsKey(prefix)) continue;
                childNameSpaces.put(prefix, (String)entry.getValue());
            }
        }
        return new InnerXMLLiteral(this, rawName, childNameSpaces);
    }

    static {
        xmlNameSpace.put("xml", xmlns);
        xmlNameSpace.put("", "");
    }
}

