/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.impl.ConsumerChoicePointFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPAgendaEntry;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterState;
import com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Generator
implements LPAgendaEntry,
LPInterpreterContext {
    protected LPInterpreter interpreter;
    protected ArrayList<Object> results = new ArrayList();
    protected Set<Object> resultSet;
    protected boolean isReady = true;
    protected boolean checkReadyNeeded = false;
    protected Set<ConsumerChoicePointFrame> generatingCPs = new HashSet<ConsumerChoicePointFrame>();
    protected Set<ConsumerChoicePointFrame> consumingCPs = new HashSet<ConsumerChoicePointFrame>();
    protected LFlag completionState;
    protected TriplePattern goal;
    protected boolean isSingleton;

    public Generator(LPInterpreter interpreter, TriplePattern goal) {
        this.interpreter = interpreter;
        this.goal = goal;
        this.isSingleton = goal.isGround();
        if (!this.isSingleton) {
            this.resultSet = new HashSet<Object>();
        }
    }

    public int numResults() {
        return this.results.size();
    }

    @Override
    public boolean isReady() {
        if (this.isComplete()) {
            return false;
        }
        if (this.checkReadyNeeded) {
            this.isReady = false;
            for (ConsumerChoicePointFrame generatingCP : this.generatingCPs) {
                if (!generatingCP.isReady()) continue;
                this.isReady = true;
                break;
            }
            this.checkReadyNeeded = false;
            return this.isReady;
        }
        return this.isReady;
    }

    @Override
    public void setReady(ConsumerChoicePointFrame ccp) {
        if (!this.isComplete()) {
            this.interpreter.engine.schedule(ccp);
            this.isReady = true;
            this.checkReadyNeeded = false;
        }
    }

    public boolean isComplete() {
        return this.interpreter == null;
    }

    public void setComplete() {
        if (!this.isComplete()) {
            this.interpreter.close();
            this.interpreter = null;
            this.resultSet = null;
            this.isReady = false;
            this.completionState = LFlag.DEAD;
            for (ConsumerChoicePointFrame ccp : this.consumingCPs) {
                if (ccp.isReady()) continue;
                ccp.setFinished();
            }
            this.generatingCPs = null;
            this.consumingCPs.clear();
        }
    }

    public void addConsumer(ConsumerChoicePointFrame ccp) {
        this.consumingCPs.add(ccp);
    }

    public void removeConsumer(ConsumerChoicePointFrame ccp) {
        this.consumingCPs.remove(ccp);
    }

    public void notifyResults() {
        LPBRuleEngine engine = this.interpreter.getEngine();
        for (ConsumerChoicePointFrame cons : this.consumingCPs) {
            cons.setReady();
        }
    }

    @Override
    public void notifyBlockedOn(ConsumerChoicePointFrame ccp) {
        this.generatingCPs.add(ccp);
        this.checkReadyNeeded = true;
    }

    @Override
    public void notifyFinished(ConsumerChoicePointFrame ccp) {
        if (this.generatingCPs != null) {
            this.generatingCPs.remove(ccp);
        }
        this.checkReadyNeeded = true;
    }

    @Override
    public void pump() {
        this.pump(this);
    }

    public void pump(LPInterpreterState context) {
        if (this.isComplete()) {
            return;
        }
        this.interpreter.setState(context);
        int priorNresults = this.results.size();
        while (true) {
            Object result;
            if ((result = this.interpreter.next()) == StateFlag.FAIL) {
                this.checkReadyNeeded = true;
                break;
            }
            if (this.isSingleton) {
                this.results.add(result);
                this.isReady = false;
                break;
            }
            if (!this.resultSet.add(result)) continue;
            this.results.add(result);
        }
        if (this.results.size() > priorNresults) {
            this.notifyResults();
        }
        if (this.isSingleton && this.results.size() == 1) {
            this.setComplete();
        }
    }

    @Override
    public Generator getGenerator() {
        return this;
    }

    public void checkForCompletions() {
        HashSet<Generator> visited = new HashSet<Generator>();
        if (this.runCompletionCheck(visited) != LFlag.LIVE) {
            Generator.postCompletionCheckScan(visited);
        }
    }

    public static void checkForCompletions(Collection<? extends Generator> completions) {
        HashSet<Generator> visited = new HashSet<Generator>();
        boolean atLeastOneZombie = false;
        for (Generator generator : completions) {
            if (generator.runCompletionCheck(visited) == LFlag.LIVE) continue;
            atLeastOneZombie = true;
        }
        if (atLeastOneZombie) {
            Generator.postCompletionCheckScan(visited);
        }
    }

    protected LFlag runCompletionCheck(Set<Generator> visited) {
        if (this.isComplete()) {
            return LFlag.DEAD;
        }
        if (!visited.add(this)) {
            return this.completionState;
        }
        this.completionState = LFlag.UNKNOWN;
        if (this.isReady()) {
            this.completionState = LFlag.LIVE;
        } else {
            for (ConsumerChoicePointFrame ccp : this.generatingCPs) {
                if (ccp.isReady()) {
                    this.completionState = LFlag.LIVE;
                    break;
                }
                if (ccp.generator.runCompletionCheck(visited) != LFlag.LIVE) continue;
                this.completionState = LFlag.LIVE;
                break;
            }
        }
        return this.completionState;
    }

    protected static void postCompletionCheckScan(Set<Generator> visited) {
        for (Generator g2 : visited) {
            if (g2.completionState != LFlag.LIVE) continue;
            Iterator<ConsumerChoicePointFrame> i = g2.consumingCPs.iterator();
            while (i.hasNext()) {
                LPInterpreterContext link = i.next().getConsumingContext();
                if (!(link instanceof Generator)) continue;
                ((Generator)link).propagateLive(visited);
            }
        }
        for (Generator g2 : visited) {
            if (g2.completionState == LFlag.LIVE) continue;
            g2.setComplete();
        }
    }

    protected void propagateLive(Set<Generator> filter) {
        if (this.completionState != LFlag.LIVE) {
            this.completionState = LFlag.LIVE;
            for (ConsumerChoicePointFrame consumingCP : this.consumingCPs) {
                LPInterpreterContext link = consumingCP.getConsumingContext();
                if (!(link instanceof Generator)) continue;
                ((Generator)link).propagateLive(filter);
            }
        }
    }

    private static class LFlag {
        private String label;
        public static final LFlag LIVE = new LFlag("Live");
        public static final LFlag DEAD = new LFlag("Dead");
        public static final LFlag UNKNOWN = new LFlag("Unknown");

        private LFlag(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

