/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEEngine;
import com.hp.hpl.jena.util.iterator.ClosableIterator;

public class RETERuleContext
implements RuleContext {
    protected BindingEnvironment env;
    protected Rule rule;
    protected ForwardRuleInfGraphI graph;
    protected RETEEngine engine;

    public RETERuleContext(ForwardRuleInfGraphI graph, RETEEngine engine) {
        this.graph = graph;
        this.engine = engine;
    }

    @Override
    public BindingEnvironment getEnv() {
        return this.env;
    }

    @Override
    public InfGraph getGraph() {
        return this.graph;
    }

    public RETEEngine getEngine() {
        return this.engine;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void setEnv(BindingEnvironment env) {
        this.env = env;
    }

    @Override
    public boolean contains(Triple t) {
        return this.contains(t.getSubject(), t.getPredicate(), t.getObject());
    }

    @Override
    public boolean contains(Node s2, Node p, Node o) {
        ClosableIterator<Triple> it = this.find(s2, p, o);
        boolean result = it.hasNext();
        it.close();
        return result;
    }

    @Override
    public ClosableIterator<Triple> find(Node s2, Node p, Node o) {
        return this.graph.findDataMatches(s2, p, o);
    }

    @Override
    public void silentAdd(Triple t) {
        this.graph.silentAdd(t);
    }

    @Override
    public void remove(Triple t) {
        this.graph.getRawGraph().delete(t);
        this.engine.deleteTriple(t, true);
    }

    @Override
    public void add(Triple t) {
        this.engine.addTriple(t, true);
    }

    public boolean shouldFire(boolean allowUnsafe) {
        for (int i = 0; i < this.rule.bodyLength(); ++i) {
            ClauseEntry clause = this.rule.getBodyElement(i);
            if (!(clause instanceof Functor) || !(allowUnsafe ? !((Functor)clause).evalAsBodyClause(this) : !((Functor)clause).safeEvalAsBodyClause(this))) continue;
            return false;
        }
        return true;
    }

    public boolean shouldStillFire() {
        for (int i = 0; i < this.rule.bodyLength(); ++i) {
            Builtin builtin;
            ClauseEntry clause = this.rule.getBodyElement(i);
            if (!(clause instanceof Functor) || (builtin = ((Functor)clause).getImplementor()) == null || builtin.isMonotonic() || ((Functor)clause).evalAsBodyClause(this)) continue;
            return false;
        }
        return true;
    }
}

