/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDAbstractDateTimeType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDBaseNumericType;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.Function;
import com.hp.hpl.jena.sparql.function.FunctionBase1;
import com.hp.hpl.jena.sparql.function.FunctionFactory;

public class CastXSD
implements FunctionFactory {
    protected final XSDDatatype castType;

    public CastXSD(XSDDatatype dt) {
        this.castType = dt;
    }

    @Override
    public Function create(String uri) {
        return new Instance(this.castType);
    }

    protected static class Instance
    extends FunctionBase1 {
        XSDDatatype castType;
        static boolean whitespaceSurroundAllowed = false;

        Instance(XSDDatatype dt) {
            this.castType = dt;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public NodeValue exec(NodeValue v) {
            String s2 = null;
            Node n = v.asNode();
            if (n.isBlank()) {
                throw new ExprEvalException("CastXSD: Can't cast blank nodes: " + v);
            }
            if (n.isURI()) {
                if (!this.castType.equals(XSDDatatype.XSDstring)) throw new ExprEvalException("CastXSD: Can't cast node: " + v + " to " + this.castType.getURI());
                s2 = n.getURI();
            } else {
                if (!n.isLiteral()) throw new ExprEvalException("CastXSD: Can't cast node: " + v + "(not a literal, not URI to string)");
                s2 = n.getLiteralLexicalForm();
            }
            if (s2 == null && v.isString()) {
                s2 = v.getString();
            }
            if (s2 != null) return this.cast(s2, v, this.castType);
            throw new ExprEvalException("CastXSD: Can't cast: " + v + "(has no string appearance)");
        }

        protected NodeValue cast(String s2, NodeValue nv, XSDDatatype castType2) {
            if (whitespaceSurroundAllowed) {
                s2 = s2.trim();
            } else if ((this.castType instanceof XSDBaseNumericType || this.castType.equals(XSDDatatype.XSDfloat) || this.castType.equals(XSDDatatype.XSDdouble) || this.castType.equals(XSDDatatype.XSDboolean) || this.castType instanceof XSDAbstractDateTimeType) && (s2.startsWith(" ") || s2.endsWith(" "))) {
                throw new ExprEvalException("CastXSD: Not a valid literal form (has whitespace): '" + s2 + "'");
            }
            try {
                if (!this.castType.isValid(s2)) {
                    throw new ExprEvalException("CastXSD: Not a valid literal form: '" + s2 + "'");
                }
                return NodeValue.makeNode(s2, this.castType);
            }
            catch (RuntimeException ex) {
                throw new ExprEvalException("CastXSD: Not a strictly valid literal form: '" + s2 + "'");
            }
        }
    }
}

