/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.inventory;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.RevisionNum;
import edu.wisc.library.ocfl.core.util.ObjectMappers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;

public class InventoryMapper {
    private final ObjectMapper objectMapper;

    public static InventoryMapper prettyPrintMapper() {
        return new InventoryMapper(ObjectMappers.prettyPrintMapper());
    }

    public static InventoryMapper defaultMapper() {
        return new InventoryMapper(ObjectMappers.defaultMapper());
    }

    public InventoryMapper(ObjectMapper objectMapper) {
        this.objectMapper = Enforce.notNull(objectMapper, "objectMapper cannot be null");
    }

    public void write(Path destination, Inventory inventory) {
        try {
            this.objectMapper.writeValue(destination.toFile(), (Object)inventory);
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
    }

    public void write(OutputStream outputStream, Inventory inventory) {
        try {
            this.objectMapper.writeValue(outputStream, (Object)inventory);
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
    }

    public Inventory read(String objectRootPath, String digest, Path path) {
        return this.readInternal(false, null, objectRootPath, digest, path);
    }

    public Inventory read(String objectRootPath, String digest, InputStream inputStream) {
        return this.readInternal(false, null, objectRootPath, digest, inputStream);
    }

    public Inventory readMutableHead(String objectRootPath, String digest, RevisionNum revisionNum, Path path) {
        return this.readInternal(true, revisionNum, objectRootPath, digest, path);
    }

    public Inventory readMutableHead(String objectRootPath, String digest, RevisionNum revisionNum, InputStream inputStream) {
        return this.readInternal(true, revisionNum, objectRootPath, digest, inputStream);
    }

    private Inventory readInternal(boolean mutableHead, RevisionNum revisionNum, String objectRootPath, String digest, Path path) {
        Enforce.notBlank(digest, "digest cannot be blank");
        try {
            return (Inventory)this.objectMapper.reader(new InjectableValues.Std().addValue("revisionNum", (Object)revisionNum).addValue("mutableHead", (Object)mutableHead).addValue("objectRootPath", (Object)objectRootPath).addValue("currentDigest", (Object)digest)).forType(Inventory.class).readValue(path.toFile());
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
    }

    private Inventory readInternal(boolean mutableHead, RevisionNum revisionNum, String objectRootPath, String digest, InputStream inputStream) {
        Enforce.notBlank(digest, "digest cannot be blank");
        try {
            return (Inventory)this.objectMapper.reader(new InjectableValues.Std().addValue("revisionNum", (Object)revisionNum).addValue("mutableHead", (Object)mutableHead).addValue("objectRootPath", (Object)objectRootPath).addValue("currentDigest", (Object)digest)).forType(Inventory.class).readValue(inputStream);
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
    }
}

