/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.inventory;

import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.VersionInfo;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.InventoryBuilder;
import edu.wisc.library.ocfl.core.model.VersionBuilder;
import edu.wisc.library.ocfl.core.validation.InventoryValidator;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Set;

public final class MutableHeadInventoryCommitter {
    private MutableHeadInventoryCommitter() {
    }

    public static Inventory commit(Inventory original, OffsetDateTime createdTimestamp, VersionInfo versionInfo) {
        Enforce.notNull(original, "inventory cannot be null");
        Enforce.notNull(createdTimestamp, "createdTimestamp cannot be null");
        InventoryBuilder inventoryBuilder = new InventoryBuilder(original).mutableHead(false).revisionNum(null);
        VersionBuilder versionBuilder = new VersionBuilder(original.getHeadVersion()).created(createdTimestamp).versionInfo(versionInfo);
        String versionStr = original.getHead().toString();
        Set<String> mutableHeadFileIds = original.getFileIdsForMatchingFiles(Paths.get("extensions/0004-mutable-head/head", new String[0]));
        mutableHeadFileIds.forEach(fileId -> {
            String originalPath = original.getContentPath((String)fileId);
            String newPath = MutableHeadInventoryCommitter.rewritePath(originalPath, versionStr);
            Map<DigestAlgorithm, String> digests = original.getFixityForContentPath(originalPath);
            inventoryBuilder.removeContentPath(originalPath);
            inventoryBuilder.addFileToManifest((String)fileId, newPath);
            if (digests != null) {
                digests.forEach((algorithm, digest) -> inventoryBuilder.addFixityForFile(newPath, (DigestAlgorithm)algorithm, (String)digest));
            }
        });
        return InventoryValidator.validateShallow(inventoryBuilder.putVersion(original.getHead(), versionBuilder.build()).build());
    }

    private static String rewritePath(String path, String version2) {
        return path.replace("extensions/0004-mutable-head/head", version2);
    }
}

