/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.lock;

import edu.wisc.library.ocfl.api.exception.LockException;
import edu.wisc.library.ocfl.api.exception.OcflDbException;
import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.lock.ObjectLock;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2ObjectLock
implements ObjectLock {
    private static final Logger LOG = LoggerFactory.getLogger(H2ObjectLock.class);
    private static final String OBJECT_LOCK_FAIL = "HYT00";
    private DataSource dataSource;
    private long waitMillis;

    public H2ObjectLock(DataSource dataSource, long waitTime, TimeUnit timeUnit) {
        this.dataSource = Enforce.notNull(dataSource, "dataSource cannot be null");
        Enforce.expressionTrue(waitTime > -1L, waitTime, "waitTime cannot be negative");
        Enforce.notNull(timeUnit, "timeUnit cannot be null");
        this.waitMillis = timeUnit.toMillis(waitTime);
    }

    @Override
    public void doInWriteLock(String objectId, Runnable doInLock) {
        this.doInWriteLock(objectId, () -> {
            doInLock.run();
            return null;
        });
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T doInWriteLock(String objectId, Callable<T> doInLock) {
        try {
            connection = this.dataSource.getConnection();
            try {
                block32: {
                    block31: {
                        connection.setAutoCommit(false);
                        this.setLockWaitTimeout(connection);
                        this.createLockRow(objectId, connection);
                        statement = this.acquireLock(connection);
                        statement.setString(1, objectId);
                        resultSet = statement.executeQuery();
                        if (!resultSet.next()) ** break block30
                        var6_13 = doInLock.call();
                        if (resultSet == null) break block31;
                        resultSet.close();
                    }
                    if (statement == null) break block32;
                    statement.close();
                }
                return var6_13;
                {
                    try {
                        try {
                            throw this.failedToAcquireLock(objectId);
                            {
                                catch (Throwable var6_14) {
                                    if (resultSet != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (Throwable var7_16) {
                                            var6_14.addSuppressed(var7_16);
                                        }
                                    }
                                    throw var6_14;
                                }
                            }
                        }
                        catch (Throwable var5_11) {
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable var6_15) {
                                    var5_11.addSuppressed(var6_15);
                                }
                            }
                            throw var5_11;
                        }
                    }
                    catch (SQLException e) {
                        if ("HYT00".equals(e.getSQLState())) {
                            throw this.failedToAcquireLock(objectId);
                        }
                        throw e;
                    }
                }
                finally {
                    this.safeCleanup(connection);
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            throw new OcflDbException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OcflJavaException(e);
        }
    }

    private void createLockRow(String objectId, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("MERGE INTO ocfl_object_lock (object_id) VALUES (?)");){
            statement.setString(1, objectId);
            statement.executeUpdate();
        }
    }

    private void setLockWaitTimeout(Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(String.format("SET LOCK_TIMEOUT %s", this.waitMillis));){
            statement.executeUpdate();
        }
    }

    private LockException failedToAcquireLock(String objectId) {
        return new LockException("Failed to acquire lock for object " + objectId);
    }

    private PreparedStatement acquireLock(Connection connection) throws SQLException {
        return connection.prepareStatement("SELECT object_id FROM ocfl_object_lock WHERE object_id = ? FOR UPDATE");
    }

    private void safeCleanup(Connection connection) {
        try {
            connection.commit();
        }
        catch (Exception e2) {
            LOG.warn("Failed to commit", e2);
        }
        try {
            connection.setAutoCommit(true);
        }
        catch (Exception e3) {
            LOG.warn("Failed to enable autocommit", e3);
        }
    }
}

