/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage;

import edu.wisc.library.ocfl.api.exception.OcflStateException;
import edu.wisc.library.ocfl.api.model.OcflVersion;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.inventory.InventoryMapper;
import edu.wisc.library.ocfl.core.storage.OcflStorage;

public abstract class AbstractOcflStorage
implements OcflStorage {
    protected InventoryMapper inventoryMapper;
    protected OcflVersion ocflVersion;
    private boolean closed = false;
    private boolean initialized = false;

    @Override
    public synchronized void initializeStorage(OcflVersion ocflVersion, OcflExtensionConfig layoutConfig, InventoryMapper inventoryMapper) {
        if (this.initialized) {
            return;
        }
        this.inventoryMapper = Enforce.notNull(inventoryMapper, "inventoryMapper cannot be null");
        this.ocflVersion = Enforce.notNull(ocflVersion, "ocflVersion cannot be null");
        this.doInitialize(layoutConfig);
        this.initialized = true;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    protected abstract void doInitialize(OcflExtensionConfig var1);

    protected void ensureOpen() {
        if (this.closed) {
            throw new OcflStateException(this.getClass().getName() + " is closed.");
        }
        if (!this.initialized) {
            throw new OcflStateException(this.getClass().getName() + " must be initialized before it can be used.");
        }
    }
}

