/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.filesystem;

import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.core.storage.OcflObjectRootDirIterator;
import edu.wisc.library.ocfl.core.util.FileUtil;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;

public class FileSystemOcflObjectRootDirIterator
extends OcflObjectRootDirIterator {
    public FileSystemOcflObjectRootDirIterator(Path start) {
        super(FileUtil.pathToStringStandardSeparator(start));
    }

    @Override
    protected boolean isObjectRoot(String path) {
        boolean bl;
        block8: {
            DirectoryStream<Path> objectMarkers = Files.newDirectoryStream(Paths.get(path, new String[0]), p -> p.getFileName().toString().startsWith("0=ocfl_object"));
            try {
                bl = objectMarkers.iterator().hasNext();
                if (objectMarkers == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (objectMarkers != null) {
                        try {
                            objectMarkers.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new OcflIOException(e2);
                }
            }
            objectMarkers.close();
        }
        return bl;
    }

    @Override
    protected OcflObjectRootDirIterator.Directory createDirectory(String path) {
        return new FileSystemDirectory(path);
    }

    private static class FileSystemDirectory
    implements OcflObjectRootDirIterator.Directory {
        private final DirectoryStream<Path> stream;
        private final Iterator<Path> children;

        FileSystemDirectory(String path) {
            try {
                this.stream = Files.newDirectoryStream(Paths.get(path, new String[0]));
                this.children = this.stream.iterator();
            }
            catch (IOException e2) {
                throw new OcflIOException(e2);
            }
        }

        @Override
        public String nextChildDirectory() {
            while (this.children.hasNext()) {
                Path child = this.children.next();
                if (!Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                return FileUtil.pathToStringStandardSeparator(child);
            }
            return null;
        }

        @Override
        public void close() {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

