/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.filesystem;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.storage.filesystem.FileSystemOcflStorage;
import edu.wisc.library.ocfl.core.storage.filesystem.FileSystemOcflStorageInitializer;
import edu.wisc.library.ocfl.core.util.ObjectMappers;
import java.nio.file.Path;

public class FileSystemOcflStorageBuilder {
    private Path repositoryRoot;
    private boolean checkNewVersionFixity = false;
    private ObjectMapper objectMapper = ObjectMappers.prettyPrintMapper();
    private FileSystemOcflStorageInitializer initializer;

    public FileSystemOcflStorageBuilder repositoryRoot(Path repositoryRoot) {
        this.repositoryRoot = Enforce.notNull(repositoryRoot, "repositoryRoot cannot be null");
        return this;
    }

    public FileSystemOcflStorageBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = Enforce.notNull(objectMapper, "objectMapper cannot be null");
        return this;
    }

    public FileSystemOcflStorageBuilder checkNewVersionFixity(boolean checkNewVersionFixity) {
        this.checkNewVersionFixity = checkNewVersionFixity;
        return this;
    }

    public FileSystemOcflStorageBuilder initializer(FileSystemOcflStorageInitializer initializer) {
        this.initializer = initializer;
        return this;
    }

    public FileSystemOcflStorage build() {
        FileSystemOcflStorageInitializer init = this.initializer;
        if (init == null) {
            init = new FileSystemOcflStorageInitializer(this.objectMapper);
        }
        return new FileSystemOcflStorage(this.repositoryRoot, this.checkNewVersionFixity, init);
    }
}

