/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.util;

import edu.wisc.library.ocfl.api.exception.OcflIOException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public final class UncheckedFiles {
    private UncheckedFiles() {
    }

    public static Path createDirectories(Path path) {
        try {
            return Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
    }

    public static Path createDirectory(Path path) {
        try {
            return Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
    }

    public static void copy(Path src, Path dst, StandardCopyOption ... copyOptions) {
        try {
            Files.copy(src, dst, (CopyOption[])copyOptions);
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
    }

    public static void copy(InputStream input, Path dst, StandardCopyOption ... copyOptions) {
        try {
            Files.copy(input, dst, (CopyOption[])copyOptions);
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
    }

    public static void delete(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
    }

    public static long size(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
    }
}

