/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.AsyncExecution;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.function.AsyncRunnable;
import net.jodah.failsafe.function.AsyncSupplier;
import net.jodah.failsafe.function.CheckedConsumer;
import net.jodah.failsafe.function.CheckedFunction;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.function.CheckedSupplier;
import net.jodah.failsafe.function.ContextualRunnable;
import net.jodah.failsafe.function.ContextualSupplier;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.concurrent.Scheduler;

final class Functions {
    private static final CompletableFuture<ExecutionResult> NULL_FUTURE = CompletableFuture.completedFuture(null);

    Functions() {
    }

    static <T> Supplier<ExecutionResult> get(CheckedSupplier<T> supplier, AbstractExecution execution) {
        return () -> {
            ExecutionResult result;
            Throwable throwable = null;
            try {
                execution.preExecute();
                result = ExecutionResult.success(supplier.get());
            }
            catch (Throwable t) {
                throwable = t;
                result = ExecutionResult.failure(t);
            }
            finally {
                AbstractExecution abstractExecution = execution;
                synchronized (abstractExecution) {
                    execution.canInterrupt = false;
                    if (execution.interrupted) {
                        Thread.interrupted();
                    } else if (throwable instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            execution.record(result);
            return result;
        };
    }

    static <T> Supplier<CompletableFuture<ExecutionResult>> getPromise(ContextualSupplier<T> supplier, AbstractExecution execution) {
        Assert.notNull(supplier, "supplier");
        return () -> {
            ExecutionResult result;
            try {
                execution.preExecute();
                result = ExecutionResult.success(supplier.get(execution));
            }
            catch (Throwable t) {
                result = ExecutionResult.failure(t);
            }
            execution.record(result);
            return CompletableFuture.completedFuture(result);
        };
    }

    static Supplier<CompletableFuture<ExecutionResult>> getPromiseAsync(Supplier<CompletableFuture<ExecutionResult>> supplier, Scheduler scheduler, FailsafeFuture<Object> future) {
        AtomicBoolean scheduled = new AtomicBoolean();
        return () -> {
            if (scheduled.get()) {
                return (CompletableFuture)supplier.get();
            }
            CompletableFuture promise = new CompletableFuture();
            Callable<Object> callable = () -> Functions.lambda$null$3((Supplier)supplier, promise);
            try {
                scheduled.set(true);
                future.inject(scheduler.schedule(callable, 0L, TimeUnit.NANOSECONDS));
            }
            catch (Throwable t) {
                promise.completeExceptionally(t);
            }
            return promise;
        };
    }

    static <T> Supplier<CompletableFuture<ExecutionResult>> getPromiseExecution(final AsyncSupplier<T> supplier, final AsyncExecution execution) {
        Assert.notNull(supplier, "supplier");
        return new Supplier<CompletableFuture<ExecutionResult>>(){

            @Override
            public synchronized CompletableFuture<ExecutionResult> get() {
                try {
                    execution.preExecute();
                    supplier.get(execution);
                }
                catch (Throwable e2) {
                    execution.completeOrHandle(null, e2);
                }
                return NULL_FUTURE;
            }
        };
    }

    static <T> Supplier<CompletableFuture<ExecutionResult>> getPromiseOfStage(ContextualSupplier<? extends CompletionStage<? extends T>> supplier, AbstractExecution execution) {
        Assert.notNull(supplier, "supplier");
        return () -> {
            CompletableFuture<ExecutionResult> promise = new CompletableFuture<ExecutionResult>();
            try {
                execution.preExecute();
                ((CompletionStage)supplier.get(execution)).whenComplete((result, failure) -> {
                    if (failure instanceof CompletionException) {
                        failure = failure.getCause();
                    }
                    ExecutionResult r = failure == null ? ExecutionResult.success(result) : ExecutionResult.failure(failure);
                    execution.record(r);
                    promise.complete(r);
                });
            }
            catch (Throwable t) {
                ExecutionResult result2 = ExecutionResult.failure(t);
                execution.record(result2);
                promise.complete(result2);
            }
            return promise;
        };
    }

    static <T> Supplier<CompletableFuture<ExecutionResult>> getPromiseOfStageExecution(AsyncSupplier<? extends CompletionStage<? extends T>> supplier, AsyncExecution execution) {
        Assert.notNull(supplier, "supplier");
        Semaphore asyncFutureLock = new Semaphore(1);
        return () -> {
            try {
                execution.preExecute();
                asyncFutureLock.acquire();
                ((CompletionStage)supplier.get(execution)).whenComplete((innerResult, failure) -> {
                    try {
                        if (failure != null) {
                            execution.completeOrHandle(innerResult, failure instanceof CompletionException ? failure.getCause() : failure);
                        }
                    }
                    finally {
                        asyncFutureLock.release();
                    }
                });
            }
            catch (Throwable e2) {
                try {
                    execution.completeOrHandle(null, e2);
                }
                finally {
                    asyncFutureLock.release();
                }
            }
            return NULL_FUTURE;
        };
    }

    static <T> AsyncSupplier<T> toAsyncSupplier(AsyncRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return execution -> {
            runnable.run(execution);
            return null;
        };
    }

    static <T> SettableSupplier<CompletableFuture<T>> toSettableSupplier(final Supplier<CompletableFuture<T>> supplier) {
        return new SettableSupplier<CompletableFuture<T>>(){
            volatile boolean called;
            volatile CompletableFuture<T> value;

            @Override
            public CompletableFuture<T> get() {
                if (!this.called && this.value != null) {
                    this.called = true;
                    return this.value;
                }
                return (CompletableFuture)supplier.get();
            }

            @Override
            public void set(CompletableFuture<T> value) {
                this.called = false;
                this.value = value;
            }
        };
    }

    static <T> CheckedSupplier<T> toSupplier(CheckedRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return () -> {
            runnable.run();
            return null;
        };
    }

    static <T> CheckedSupplier<T> toSupplier(ContextualRunnable runnable, ExecutionContext context) {
        Assert.notNull(runnable, "runnable");
        return () -> {
            runnable.run(context);
            return null;
        };
    }

    static <T> CheckedSupplier<T> toSupplier(ContextualSupplier<T> supplier, ExecutionContext context) {
        Assert.notNull(supplier, "supplier");
        return () -> supplier.get(context);
    }

    static <T> ContextualSupplier<T> toCtxSupplier(CheckedRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return ctx -> {
            runnable.run();
            return null;
        };
    }

    static <T> ContextualSupplier<T> toCtxSupplier(ContextualRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return ctx -> {
            runnable.run(ctx);
            return null;
        };
    }

    static <T> ContextualSupplier<T> toCtxSupplier(CheckedSupplier<T> supplier) {
        Assert.notNull(supplier, "supplier");
        return ctx -> supplier.get();
    }

    static <T, R> CheckedFunction<T, R> toFn(CheckedConsumer<T> consumer) {
        return t -> {
            consumer.accept(t);
            return null;
        };
    }

    static <T, R> CheckedFunction<T, R> toFn(CheckedRunnable runnable) {
        return t -> {
            runnable.run();
            return null;
        };
    }

    static <T, R> CheckedFunction<T, R> toFn(CheckedSupplier<R> supplier) {
        return t -> supplier.get();
    }

    static <T, R> CheckedFunction<T, R> toFn(R result) {
        return t -> result;
    }

    private static /* synthetic */ Object lambda$null$3(Supplier supplier, CompletableFuture promise) throws Exception {
        return ((CompletableFuture)supplier.get()).whenComplete((result, error) -> {
            if (error != null) {
                promise.completeExceptionally((Throwable)error);
            } else {
                promise.complete(result);
            }
        });
    }

    static interface SettableSupplier<T>
    extends Supplier<T> {
        public void set(T var1);
    }
}

