/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.data;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.util.Context;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyCount;

public class ThresholdPolicyFactory {
    private static final long defaultThreshold = -1L;
    private static final ThresholdPolicy<?> NEVER = new ThresholdPolicy<Object>(){

        @Override
        public void increment(Object item) {
        }

        @Override
        public boolean isThresholdExceeded() {
            return false;
        }

        @Override
        public void reset() {
        }
    };

    public static final <E> ThresholdPolicy<E> never() {
        ThresholdPolicy<?> policy = NEVER;
        return policy;
    }

    public static <E> ThresholdPolicy<E> count(long threshold) {
        return new ThresholdPolicyCount(threshold);
    }

    public static <E> ThresholdPolicy<E> policyFromContext(Context context) {
        long threshold = (Long)context.get(ARQ.spillToDiskThreshold, -1L);
        if (threshold >= 0L) {
            return ThresholdPolicyFactory.count(threshold);
        }
        return ThresholdPolicyFactory.never();
    }
}

