/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.lucene.index.BinaryDocValuesFieldUpdates;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.FieldTermIterator;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValuesFieldUpdates;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.RamUsageEstimator;

class FrozenBufferedUpdates {
    static final int BYTES_PER_DEL_QUERY = RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4 + 24;
    final PrefixCodedTerms deleteTerms;
    final Query[] deleteQueries;
    final int[] deleteQueryLimits;
    final byte[] numericDVUpdates;
    final byte[] binaryDVUpdates;
    private int numericDVUpdateCount;
    private int binaryDVUpdateCount;
    public final CountDownLatch applied = new CountDownLatch(1);
    public long totalDelCount;
    final int bytesUsed;
    final int numTermDeletes;
    private long delGen = -1L;
    final SegmentCommitInfo privateSegment;
    private final InfoStream infoStream;

    public FrozenBufferedUpdates(InfoStream infoStream, BufferedUpdates updates, SegmentCommitInfo privateSegment) throws IOException {
        this.infoStream = infoStream;
        this.privateSegment = privateSegment;
        assert (updates.deleteDocIDs.isEmpty());
        assert (privateSegment == null || updates.deleteTerms.isEmpty()) : "segment private packet should only have del queries";
        Comparable[] termsArray = updates.deleteTerms.keySet().toArray(new Term[updates.deleteTerms.size()]);
        ArrayUtil.timSort((Comparable[])termsArray);
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        for (Comparable term : termsArray) {
            builder.add((Term)term);
        }
        this.deleteTerms = builder.finish();
        this.deleteQueries = new Query[updates.deleteQueries.size()];
        this.deleteQueryLimits = new int[updates.deleteQueries.size()];
        int upto = 0;
        for (Map.Entry<Query, Integer> ent : updates.deleteQueries.entrySet()) {
            this.deleteQueries[upto] = ent.getKey();
            this.deleteQueryLimits[upto] = ent.getValue();
            ++upto;
        }
        this.numericDVUpdates = this.freezeNumericDVUpdates(updates.numericUpdates);
        this.binaryDVUpdates = this.freezeBinaryDVUpdates(updates.binaryUpdates);
        this.bytesUsed = (int)(this.deleteTerms.ramBytesUsed() + (long)(this.deleteQueries.length * BYTES_PER_DEL_QUERY) + (long)this.numericDVUpdates.length + (long)this.binaryDVUpdates.length);
        this.numTermDeletes = updates.numTermDeletes.get();
        if (infoStream != null && infoStream.isEnabled("BD")) {
            infoStream.message("BD", String.format(Locale.ROOT, "compressed %d to %d bytes (%.2f%%) for deletes/updates; private segment %s", updates.bytesUsed.get(), this.bytesUsed, 100.0 * (double)this.bytesUsed / (double)updates.bytesUsed.get(), privateSegment));
        }
    }

    private byte[] freezeNumericDVUpdates(Map<String, LinkedHashMap<Term, DocValuesUpdate.NumericDocValuesUpdate>> numericDVUpdates) throws IOException {
        RAMOutputStream out = new RAMOutputStream();
        String lastTermField = null;
        String lastUpdateField = null;
        for (LinkedHashMap<Term, DocValuesUpdate.NumericDocValuesUpdate> numericUpdates : numericDVUpdates.values()) {
            this.numericDVUpdateCount += numericUpdates.size();
            for (DocValuesUpdate.NumericDocValuesUpdate update2 : numericUpdates.values()) {
                String updateField;
                int code = update2.term.bytes().length << 2;
                String termField = update2.term.field();
                if (!termField.equals(lastTermField)) {
                    code |= 1;
                }
                if (!(updateField = update2.field).equals(lastUpdateField)) {
                    code |= 2;
                }
                out.writeVInt(code);
                out.writeVInt(update2.docIDUpto);
                if ((code & 1) != 0) {
                    out.writeString(termField);
                    lastTermField = termField;
                }
                if ((code & 2) != 0) {
                    out.writeString(updateField);
                    lastUpdateField = updateField;
                }
                out.writeBytes(update2.term.bytes().bytes, update2.term.bytes().offset, update2.term.bytes().length);
                out.writeZLong((Long)update2.value);
            }
        }
        byte[] bytes = new byte[(int)out.getFilePointer()];
        out.writeTo(bytes, 0);
        return bytes;
    }

    private byte[] freezeBinaryDVUpdates(Map<String, LinkedHashMap<Term, DocValuesUpdate.BinaryDocValuesUpdate>> binaryDVUpdates) throws IOException {
        RAMOutputStream out = new RAMOutputStream();
        String lastTermField = null;
        String lastUpdateField = null;
        for (LinkedHashMap<Term, DocValuesUpdate.BinaryDocValuesUpdate> binaryUpdates : binaryDVUpdates.values()) {
            this.binaryDVUpdateCount += binaryUpdates.size();
            for (DocValuesUpdate.BinaryDocValuesUpdate update2 : binaryUpdates.values()) {
                String updateField;
                int code = update2.term.bytes().length << 2;
                String termField = update2.term.field();
                if (!termField.equals(lastTermField)) {
                    code |= 1;
                }
                if (!(updateField = update2.field).equals(lastUpdateField)) {
                    code |= 2;
                }
                out.writeVInt(code);
                out.writeVInt(update2.docIDUpto);
                if (!termField.equals(lastTermField)) {
                    out.writeString(termField);
                    lastTermField = termField;
                }
                if (!updateField.equals(lastUpdateField)) {
                    out.writeString(updateField);
                    lastUpdateField = updateField;
                }
                out.writeBytes(update2.term.bytes().bytes, update2.term.bytes().offset, update2.term.bytes().length);
                BytesRef value = (BytesRef)update2.value;
                out.writeVInt(value.length);
                out.writeBytes(value.bytes, value.offset, value.length);
            }
        }
        byte[] bytes = new byte[(int)out.getFilePointer()];
        out.writeTo(bytes, 0);
        return bytes;
    }

    private List<SegmentCommitInfo> getInfosToApply(IndexWriter writer) {
        List<SegmentCommitInfo> infos;
        assert (Thread.holdsLock(writer));
        if (this.privateSegment != null) {
            if (writer.segmentInfos.indexOf(this.privateSegment) == -1) {
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", "private segment already gone; skip processing updates");
                }
                return null;
            }
            infos = Collections.singletonList(this.privateSegment);
        } else {
            infos = writer.segmentInfos.asList();
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void apply(IndexWriter writer) throws IOException {
        if (this.applied.getCount() == 0L) {
            return;
        }
        long startNS = System.nanoTime();
        assert (this.any());
        HashSet<SegmentCommitInfo> seenSegments = new HashSet<SegmentCommitInfo>();
        int iter = 0;
        int totalSegmentCount = 0;
        long totalDelCount = 0L;
        boolean finished = false;
        while (true) {
            long delCount;
            BufferedUpdatesStream.SegmentState[] segStates;
            String messagePrefix = iter == 0 ? "" : "iter " + iter;
            long iterStartNS = System.nanoTime();
            long mergeGenStart = writer.mergeFinishedGen.get();
            HashSet<String> delFiles = new HashSet<String>();
            IndexWriter indexWriter = writer;
            synchronized (indexWriter) {
                List<SegmentCommitInfo> infos = this.getInfosToApply(writer);
                if (infos == null) {
                    break;
                }
                for (SegmentCommitInfo info : infos) {
                    delFiles.addAll(info.files());
                }
                segStates = writer.bufferedUpdatesStream.openSegmentStates(writer.readerPool, infos, seenSegments, this.delGen());
                if (segStates.length == 0) {
                    if (this.infoStream.isEnabled("BD")) {
                        this.infoStream.message("BD", "packet matches no segments");
                    }
                    break;
                }
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", String.format(Locale.ROOT, messagePrefix + "now apply del packet (%s) to %d segments, mergeGen %d", this, segStates.length, mergeGenStart));
                }
                totalSegmentCount += segStates.length;
                writer.deleter.incRef(delFiles);
            }
            boolean success = false;
            try {
                delCount = this.apply(segStates);
                success = true;
            }
            finally {
                this.finishApply(writer, segStates, success, delFiles);
            }
            writer.readerPool.writeSomeDocValuesUpdates();
            totalDelCount += delCount;
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", String.format(Locale.ROOT, messagePrefix + "done inner apply del packet (%s) to %d segments; %d new deletes/updates; took %.3f sec", this, segStates.length, delCount, (double)(System.nanoTime() - iterStartNS) / 1.0E9));
            }
            if (this.privateSegment != null) break;
            IndexWriter indexWriter2 = writer;
            synchronized (indexWriter2) {
                long mergeGenCur = writer.mergeFinishedGen.get();
                if (mergeGenCur == mergeGenStart) {
                    writer.bufferedUpdatesStream.finished(this);
                    finished = true;
                    break;
                }
            }
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", messagePrefix + "concurrent merges finished; move to next iter");
            }
            ++iter;
        }
        if (!finished) {
            writer.bufferedUpdatesStream.finished(this);
        }
        if (this.infoStream.isEnabled("BD")) {
            String message = String.format(Locale.ROOT, "done apply del packet (%s) to %d segments; %d new deletes/updates; took %.3f sec", this, totalSegmentCount, totalDelCount, (double)(System.nanoTime() - startNS) / 1.0E9);
            if (iter > 0) {
                message = message + "; " + (iter + 1) + " iters due to concurrent merges";
            }
            message = message + "; " + writer.bufferedUpdatesStream.getPendingUpdatesCount() + " packets remain";
            this.infoStream.message("BD", message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishApply(IndexWriter writer, BufferedUpdatesStream.SegmentState[] segStates, boolean success, Set<String> delFiles) throws IOException {
        IndexWriter indexWriter = writer;
        synchronized (indexWriter) {
            BufferedUpdatesStream.ApplyDeletesResult result;
            try {
                result = writer.bufferedUpdatesStream.closeSegmentStates(writer.readerPool, segStates, success);
            }
            finally {
                writer.deleter.decRef(delFiles);
            }
            if (result.anyDeletes) {
                writer.maybeMerge.set(true);
                writer.checkpoint();
            }
            if (!writer.keepFullyDeletedSegments && result.allDeleted != null) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "drop 100% deleted segments: " + writer.segString(result.allDeleted));
                }
                for (SegmentCommitInfo info : result.allDeleted) {
                    writer.dropDeletedSegment(info);
                }
                writer.checkpoint();
            }
        }
    }

    private synchronized long apply(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.delGen == -1L) {
            throw new IllegalArgumentException("gen is not yet set; call BufferedUpdatesStream.push first");
        }
        assert (this.applied.getCount() != 0L);
        if (this.privateSegment != null) {
            assert (segStates.length == 1);
            assert (this.privateSegment == segStates[0].reader.getSegmentInfo());
        }
        this.totalDelCount += this.applyTermDeletes(segStates);
        this.totalDelCount += this.applyQueryDeletes(segStates);
        this.totalDelCount += this.applyDocValuesUpdates(segStates);
        return this.totalDelCount;
    }

    private long applyDocValuesUpdates(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.numericDVUpdates.length == 0 && this.binaryDVUpdates.length == 0) {
            return 0L;
        }
        long startNS = System.nanoTime();
        long updateCount = 0L;
        for (BufferedUpdatesStream.SegmentState segState : segStates) {
            if (this.delGen < segState.delGen || segState.rld.refCount() == 1) continue;
            if (this.numericDVUpdates.length > 0) {
                updateCount += this.applyDocValuesUpdates(segState, this.numericDVUpdates, true);
            }
            if (this.binaryDVUpdates.length <= 0) continue;
            updateCount += this.applyDocValuesUpdates(segState, this.binaryDVUpdates, false);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyDocValuesUpdates %.1f msec for %d segments, %d numeric updates and %d binary updates; %d new updates", (double)(System.nanoTime() - startNS) / 1000000.0, segStates.length, this.numericDVUpdateCount, this.binaryDVUpdateCount, updateCount));
        }
        return updateCount;
    }

    private long applyDocValuesUpdates(BufferedUpdatesStream.SegmentState segState, byte[] updates, boolean isNumeric) throws IOException {
        TermsEnum termsEnum = null;
        PostingsEnum postingsEnum = null;
        long updateCount = 0L;
        HashMap<String, DocValuesFieldUpdates> holder = new HashMap<String, DocValuesFieldUpdates>();
        ByteArrayDataInput in = new ByteArrayDataInput(updates);
        String termField = null;
        String updateField = null;
        BytesRef term = new BytesRef();
        term.bytes = new byte[16];
        BytesRef scratch = new BytesRef();
        scratch.bytes = new byte[16];
        while (in.getPosition() != updates.length) {
            int doc;
            Bits acceptDocs;
            Comparable<BytesRef> value;
            int limit;
            int code = in.readVInt();
            int docIDUpto = in.readVInt();
            term.length = code >> 2;
            if ((code & 1) != 0) {
                termField = in.readString();
            }
            if ((code & 2) != 0) {
                updateField = in.readString();
            }
            if (term.bytes.length < term.length) {
                term.bytes = ArrayUtil.grow(term.bytes, term.length);
            }
            in.readBytes(term.bytes, 0, term.length);
            if (this.delGen == segState.delGen) {
                assert (this.privateSegment != null);
                limit = docIDUpto;
            } else {
                limit = Integer.MAX_VALUE;
            }
            if ((code & 1) != 0) {
                Terms terms = segState.reader.terms(termField);
                termsEnum = terms != null ? terms.iterator() : null;
            }
            if (isNumeric) {
                value = in.readZLong();
            } else {
                value = scratch;
                scratch.length = in.readVInt();
                if (scratch.bytes.length < scratch.length) {
                    scratch.bytes = ArrayUtil.grow(scratch.bytes, scratch.length);
                }
                in.readBytes(scratch.bytes, 0, scratch.length);
            }
            if (termsEnum == null || !termsEnum.seekExact(term)) continue;
            postingsEnum = termsEnum.postings(postingsEnum, 0);
            DocValuesFieldUpdates dvUpdates = (DocValuesFieldUpdates)holder.get(updateField);
            if (dvUpdates == null) {
                dvUpdates = isNumeric ? new NumericDocValuesFieldUpdates(this.delGen, updateField, segState.reader.maxDoc()) : new BinaryDocValuesFieldUpdates(this.delGen, updateField, segState.reader.maxDoc());
                holder.put(updateField, dvUpdates);
            }
            if (segState.rld.sortMap != null && this.privateSegment != null) {
                acceptDocs = segState.rld.getLiveDocs();
                while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    if (acceptDocs != null && !acceptDocs.get(doc) || segState.rld.sortMap.newToOld(doc) >= limit) continue;
                    dvUpdates.add(doc, value);
                    ++updateCount;
                }
                continue;
            }
            acceptDocs = segState.rld.getLiveDocs();
            while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE && doc < limit) {
                if (acceptDocs != null && !acceptDocs.get(doc)) continue;
                dvUpdates.add(doc, value);
                ++updateCount;
            }
        }
        for (DocValuesFieldUpdates update2 : holder.values()) {
            if (!update2.any()) continue;
            update2.finish();
            segState.rld.addDVUpdate(update2);
        }
        return updateCount;
    }

    private long applyQueryDeletes(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.deleteQueries.length == 0) {
            return 0L;
        }
        long startNS = System.nanoTime();
        long delCount = 0L;
        for (BufferedUpdatesStream.SegmentState segState : segStates) {
            if (this.delGen < segState.delGen || segState.rld.refCount() == 1) continue;
            LeafReaderContext readerContext = segState.reader.getContext();
            for (int i = 0; i < this.deleteQueries.length; ++i) {
                int docID;
                int limit;
                Query query2 = this.deleteQueries[i];
                if (this.delGen == segState.delGen) {
                    assert (this.privateSegment != null);
                    limit = this.deleteQueryLimits[i];
                } else {
                    limit = Integer.MAX_VALUE;
                }
                IndexSearcher searcher = new IndexSearcher(readerContext.reader());
                searcher.setQueryCache(null);
                Weight weight = searcher.createNormalizedWeight(query2, false);
                Scorer scorer = weight.scorer(readerContext);
                if (scorer == null) continue;
                DocIdSetIterator it = scorer.iterator();
                while ((docID = it.nextDoc()) < limit) {
                    if (!segState.rld.delete(docID)) continue;
                    ++delCount;
                }
            }
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyQueryDeletes took %.2f msec for %d segments and %d queries; %d new deletions", (double)(System.nanoTime() - startNS) / 1000000.0, segStates.length, this.deleteQueries.length, delCount));
        }
        return delCount;
    }

    private long applyTermDeletes(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.deleteTerms.size() == 0L) {
            return 0L;
        }
        assert (this.privateSegment == null);
        try {
            long startNS = System.nanoTime();
            long delCount = 0L;
            for (BufferedUpdatesStream.SegmentState segState : segStates) {
                BytesRef delTerm;
                assert (segState.delGen != this.delGen) : "segState.delGen=" + segState.delGen + " vs this.gen=" + this.delGen;
                if (segState.delGen > this.delGen || segState.rld.refCount() == 1) continue;
                PrefixCodedTerms.TermIterator iter = this.deleteTerms.iterator();
                String field = null;
                TermsEnum termsEnum = null;
                BytesRef readerTerm = null;
                PostingsEnum postingsEnum = null;
                while ((delTerm = iter.next()) != null) {
                    int docID;
                    TermsEnum.SeekStatus status;
                    int cmp;
                    if (((FieldTermIterator)iter).field() != field) {
                        field = ((FieldTermIterator)iter).field();
                        Terms terms = segState.reader.terms(field);
                        if (terms != null) {
                            termsEnum = terms.iterator();
                            readerTerm = termsEnum.next();
                        } else {
                            termsEnum = null;
                        }
                    }
                    if (termsEnum == null || (cmp = delTerm.compareTo(readerTerm)) < 0) continue;
                    if (cmp != 0 && cmp > 0 && (status = termsEnum.seekCeil(delTerm)) != TermsEnum.SeekStatus.FOUND) {
                        if (status == TermsEnum.SeekStatus.NOT_FOUND) {
                            readerTerm = termsEnum.term();
                            continue;
                        }
                        termsEnum = null;
                        continue;
                    }
                    postingsEnum = termsEnum.postings(postingsEnum, 0);
                    assert (postingsEnum != null);
                    while ((docID = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                        if (!segState.rld.delete(docID)) continue;
                        ++delCount;
                    }
                }
            }
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", String.format(Locale.ROOT, "applyTermDeletes took %.2f msec for %d segments and %d del terms; %d new deletions", (double)(System.nanoTime() - startNS) / 1000000.0, segStates.length, this.deleteTerms.size(), delCount));
            }
            return delCount;
        }
        catch (Throwable t) {
            throw IOUtils.rethrowAlways(t);
        }
    }

    public void setDelGen(long delGen) {
        assert (this.delGen == -1L) : "delGen was already previously set to " + this.delGen;
        this.delGen = delGen;
        this.deleteTerms.setDelGen(delGen);
    }

    public long delGen() {
        assert (this.delGen != -1L);
        return this.delGen;
    }

    public String toString() {
        String s2 = "delGen=" + this.delGen;
        if (this.numTermDeletes != 0) {
            s2 = s2 + " numDeleteTerms=" + this.numTermDeletes;
            if ((long)this.numTermDeletes != this.deleteTerms.size()) {
                s2 = s2 + " (" + this.deleteTerms.size() + " unique)";
            }
        }
        if (this.deleteQueries.length != 0) {
            s2 = s2 + " numDeleteQuerys=" + this.deleteQueries.length;
        }
        if (this.numericDVUpdates.length > 0) {
            s2 = s2 + " numNumericDVUpdates=" + this.numericDVUpdateCount;
        }
        if (this.binaryDVUpdates.length > 0) {
            s2 = s2 + " numBinaryDVUpdates=" + this.binaryDVUpdateCount;
        }
        if (this.bytesUsed != 0) {
            s2 = s2 + " bytesUsed=" + this.bytesUsed;
        }
        if (this.privateSegment != null) {
            s2 = s2 + " privateSegment=" + this.privateSegment;
        }
        return s2;
    }

    boolean any() {
        return this.deleteTerms.size() > 0L || this.deleteQueries.length > 0 || this.numericDVUpdates.length > 0 || this.binaryDVUpdates.length > 0;
    }

    boolean anyDeleteTerms() {
        return this.deleteTerms.size() > 0L;
    }
}

