/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.fcrepo.client.FcrepoLink;

public class FcrepoResponse
implements Closeable {
    private URI url;
    private int statusCode;
    private URI location;
    private Map<String, List<String>> headers;
    private Map<String, String> contentDisposition;
    private InputStream body;
    private String contentType;
    private boolean closed = false;

    public FcrepoResponse(URI url, int statusCode, Map<String, List<String>> headers, InputStream body) {
        this.setUrl(url);
        this.setStatusCode(statusCode);
        this.setHeaders(headers);
        this.setBody(body);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed && this.body != null) {
            try {
                this.body.close();
            }
            finally {
                this.closed = true;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public InputStream getBody() {
        return this.body;
    }

    public void setBody(InputStream body) {
        this.body = body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> getHeaderValues(String name) {
        return this.headers == null ? Collections.emptyList() : this.headers.getOrDefault(name, Collections.emptyList());
    }

    public String getHeaderValue(String name) {
        List<String> values = this.getHeaderValues(name);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public List<URI> getLinkHeaders(String relationship) {
        return this.getHeaderValues("Link").stream().map(FcrepoLink::new).filter(link -> link.getRel().equals(relationship)).map(FcrepoLink::getUri).collect(Collectors.toList());
    }

    public URI getLocation() {
        if (this.location == null && this.headers != null) {
            List<URI> links;
            String value = this.getHeaderValue("Location");
            if (value != null) {
                this.location = URI.create(this.getHeaderValue("Location"));
            }
            if (this.location == null && (links = this.getLinkHeaders("describedby")) != null && links.size() == 1) {
                this.location = links.get(0);
            }
        }
        return this.location;
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    public String getContentType() {
        if (this.contentType == null && this.headers != null) {
            this.contentType = this.getHeaderValue("Content-Type");
        }
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Map<String, String> getContentDisposition() {
        if (this.contentDisposition == null && this.headers.containsKey("Content-Disposition")) {
            List<String> values = this.headers.get("Content-Disposition");
            if (values.isEmpty()) {
                return null;
            }
            this.contentDisposition = new HashMap<String, String>();
            String value = values.get(0);
            BasicHeader header = new BasicHeader("Content-Disposition", value);
            for (HeaderElement headEl : header.getElements()) {
                for (NameValuePair pair : headEl.getParameters()) {
                    this.contentDisposition.put(pair.getName(), pair.getValue());
                }
            }
        }
        return this.contentDisposition;
    }
}

