/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.f4clients;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.FcrepoHttpClientBuilder;
import org.fcrepo.client.FcrepoOperationFailedException;
import org.fcrepo.client.FcrepoResponse;
import org.fcrepo.client.HttpMethods;
import org.fcrepo.migration.Fedora4Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessFedora4Client
implements Fedora4Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatelessFedora4Client.class);
    private String baseUri;
    private String username;
    private String password;

    public StatelessFedora4Client(String fcrepoBaseURL) {
        this.baseUri = fcrepoBaseURL;
    }

    public StatelessFedora4Client(String username, String password, String fcrepoBaseURL) {
        this.baseUri = fcrepoBaseURL;
        this.username = username;
        this.password = password;
    }

    private FcrepoClient getClient() {
        try {
            return new FcrepoClient.FcrepoClientBuilder().credentials(this.username, this.password).authScope(new URI(this.baseUri).toURL().getHost()).build();
        }
        catch (MalformedURLException | URISyntaxException e2) {
            throw new RuntimeException(e2);
        }
    }

    private boolean success(FcrepoResponse r) {
        return r.getStatusCode() >= 200 && r.getStatusCode() < 300;
    }

    private void assertSuccess(FcrepoResponse r) {
        if (!this.success(r)) {
            throw new RuntimeException("error code " + r.getStatusCode() + " from request " + r.getUrl());
        }
    }

    private URI pathToURI(String path) throws URISyntaxException {
        return path.startsWith(this.baseUri) ? new URI(path) : new URI(this.baseUri + path);
    }

    private String uriToPath(String URI2) {
        if (URI2.startsWith(this.baseUri)) {
            return URI2.substring(this.baseUri.length());
        }
        return URI2;
    }

    @Override
    public boolean exists(String path) {
        try {
            return this.getClient().head(this.pathToURI(path)).perform().getStatusCode() != 404;
        }
        catch (URISyntaxException | FcrepoOperationFailedException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void createResource(String path) {
        try {
            this.assertSuccess(this.getClient().put(this.pathToURI(path)).perform());
        }
        catch (URISyntaxException | FcrepoOperationFailedException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public String getRepositoryUrl() {
        return this.baseUri.toString();
    }

    @Override
    public void createOrUpdateRedirectNonRDFResource(String path, String url) {
        try {
            this.assertSuccess(this.getClient().put(this.pathToURI(path)).body((InputStream)null, "message/external-body; access-type=URL; URL=\"" + url.toString() + "\"").perform());
        }
        catch (URISyntaxException | FcrepoOperationFailedException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void createOrUpdateNonRDFResource(String path, InputStream content, String contentType) {
        try {
            this.assertSuccess(this.getClient().put(this.pathToURI(path)).body(content, contentType).perform());
        }
        catch (URISyntaxException | FcrepoOperationFailedException e2) {
            throw new RuntimeException(e2);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e3) {
                throw new RuntimeException(e3);
            }
        }
    }

    @Override
    public void createVersionSnapshot(String path, String versionId) {
        try {
            FcrepoHttpClientBuilder client = new FcrepoHttpClientBuilder(this.username, this.password, new URI(this.baseUri).toURL().getHost());
            try (CloseableHttpClient c = client.build();){
                HttpMethods method = HttpMethods.POST;
                URI uri = this.pathToURI(path + "/fcr:versions");
                HttpEntityEnclosingRequestBase request = (HttpEntityEnclosingRequestBase)method.createRequest(uri);
                request.addHeader("Slug", versionId);
                try (CloseableHttpResponse response = c.execute(request);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode < 200 || statusCode >= 300) {
                        throw new RuntimeException("Unable to create version! " + response.getStatusLine().toString());
                    }
                }
            }
        }
        catch (IOException | URISyntaxException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void updateResourceProperties(String path, String sparqlUpdate) {
        try {
            this.assertSuccess(this.getClient().patch(this.pathToURI(path)).body(new ByteArrayInputStream(sparqlUpdate.getBytes("UTF-8"))).perform());
        }
        catch (UnsupportedEncodingException | URISyntaxException | FcrepoOperationFailedException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void updateNonRDFResourceProperties(String path, String sparqlUpdate) {
        try {
            this.assertSuccess(this.getClient().patch(this.pathToURI(path + "/fcr:metadata")).body(new ByteArrayInputStream(sparqlUpdate.getBytes("UTF-8"))).perform());
        }
        catch (UnsupportedEncodingException | URISyntaxException | FcrepoOperationFailedException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public String createPlaceholder(String path) {
        if (path == null || path.length() == 0) {
            try {
                FcrepoResponse r = this.getClient().post(new URI(this.baseUri)).perform();
                this.assertSuccess(r);
                return this.uriToPath(r.getLocation().toString());
            }
            catch (URISyntaxException | FcrepoOperationFailedException e2) {
                throw new RuntimeException(e2);
            }
        }
        if (!this.exists(path)) {
            this.createResource(path);
        }
        return path;
    }

    @Override
    public String createNonRDFPlaceholder(String path) {
        if (!this.exists(path)) {
            if (path == null || path.length() == 0) {
                try {
                    FcrepoResponse r = this.getClient().post(new URI(this.baseUri)).body((InputStream)null, "text/plain").perform();
                    this.assertSuccess(r);
                    return this.uriToPath(r.getLocation().toString());
                }
                catch (URISyntaxException | FcrepoOperationFailedException e2) {
                    throw new RuntimeException(e2);
                }
            }
            try {
                this.assertSuccess(this.getClient().put(this.pathToURI(path)).body(new ByteArrayInputStream("".getBytes("UTF-8")), "text/xml").perform());
            }
            catch (UnsupportedEncodingException | URISyntaxException | FcrepoOperationFailedException e3) {
                throw new RuntimeException(e3);
            }
            return path;
        }
        return path;
    }

    @Override
    public boolean isPlaceholder(String path) {
        try {
            return this.getClient().get(this.pathToURI(path + "/fcr:versions")).perform().getStatusCode() == 404;
        }
        catch (URISyntaxException | FcrepoOperationFailedException e2) {
            throw new RuntimeException(e2);
        }
    }
}

