/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.modify.request.QuadAcc;
import com.hp.hpl.jena.sparql.modify.request.QuadDataAcc;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.modify.request.UpdateDeleteWhere;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.ExternalContentURLMapper;
import org.fcrepo.migration.Fedora4Client;
import org.fcrepo.migration.FedoraObjectVersionHandler;
import org.fcrepo.migration.MigrationIDMapper;
import org.fcrepo.migration.ObjectProperty;
import org.fcrepo.migration.ObjectReference;
import org.fcrepo.migration.ObjectVersionReference;
import org.fcrepo.migration.foxml.DC;
import org.fcrepo.migration.foxml.NamespacePrefixMapper;
import org.fcrepo.migration.urlmappers.SelfReferencingURLMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicObjectVersionHandler
implements FedoraObjectVersionHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(BasicObjectVersionHandler.class);
    private static int suffix = 0;
    private Fedora4Client f4client;
    private MigrationIDMapper idMapper;
    private boolean importExternal;
    private boolean importRedirect;
    private ExternalContentURLMapper externalContentUrlMapper;
    private NamespacePrefixMapper namespacePrefixMapper;
    private boolean skipDisseminators = false;
    private Properties customPropertyMapping;

    public BasicObjectVersionHandler(Fedora4Client client, MigrationIDMapper idMapper, String localFedoraServer, NamespacePrefixMapper namespacePrefixMapper) {
        this.f4client = client;
        this.idMapper = idMapper;
        this.externalContentUrlMapper = new SelfReferencingURLMapper(localFedoraServer, idMapper);
        this.namespacePrefixMapper = namespacePrefixMapper;
        ErrorHandlerFactory.setDefaultErrorHandler(ErrorHandlerFactory.errorHandlerWarn);
    }

    public void setImportExternal(boolean value) {
        this.importExternal = value;
    }

    public void setImportRedirect(boolean value) {
        this.importRedirect = value;
    }

    public void setCustomPropertyMapping(File propertiesFile) {
        this.customPropertyMapping = new Properties();
        try (FileInputStream fis = new FileInputStream(propertiesFile);){
            this.customPropertyMapping.load(fis);
        }
        catch (FileNotFoundException e2) {
            throw new RuntimeException("The file, \"" + propertiesFile.getAbsolutePath() + "\" , specified in the 'customPropertyMapping' property was not found!", e2);
        }
        catch (IOException e3) {
            throw new RuntimeException("Error access the file, \"" + propertiesFile.getAbsolutePath() + "\" , specified in the 'customPropertyMapping' property!", e3);
        }
    }

    public void setSkipDisseminators(boolean skip) {
        this.skipDisseminators = skip;
    }

    @Override
    public void processObjectVersions(Iterable<ObjectVersionReference> versions) {
        String objectPath = null;
        try {
            for (ObjectVersionReference version2 : versions) {
                LOGGER.debug("Considering object " + version2.getObjectInfo().getPid() + " version at " + version2.getVersionDate() + ".");
                if (objectPath == null) {
                    if (!this.skipDisseminators && version2.getObject().hadFedora2Disseminators()) {
                        throw new RuntimeException("Fedora 2 disseminators are not supported, set \"skipDisseminators\" to true to migration this object without the disseminators!");
                    }
                    objectPath = this.idMapper.mapObjectPath(version2.getObjectInfo().getPid());
                    if (!this.f4client.exists(objectPath)) {
                        this.f4client.createPlaceholder(objectPath);
                    } else if (!this.f4client.isPlaceholder(objectPath)) {
                        LOGGER.warn(objectPath + " already exists, skipping migration of " + version2.getObject().getObjectInfo().getPid() + "!");
                        return;
                    }
                }
                QuadDataAcc triplesToInsert = new QuadDataAcc();
                QuadAcc triplesToRemove = new QuadAcc();
                for (DatastreamVersion v : this.withRELSINTLast(version2.listChangedDatastreams())) {
                    LOGGER.debug("Considering changed datastream version " + v.getVersionId());
                    String dsPath = this.idMapper.mapDatastreamPath(v.getDatastreamInfo().getObjectInfo().getPid(), v.getDatastreamInfo().getDatastreamId());
                    if (v.getDatastreamInfo().getDatastreamId().equals("DC")) {
                        this.migrateDc(v, triplesToRemove, triplesToInsert);
                        continue;
                    }
                    if (v.getDatastreamInfo().getDatastreamId().equals("RELS-EXT")) {
                        this.migrateRelsExt(v, triplesToRemove, triplesToInsert);
                        continue;
                    }
                    if (v.getDatastreamInfo().getDatastreamId().equals("RELS-INT")) {
                        this.migrateRelsInt(v);
                        continue;
                    }
                    if (v.getDatastreamInfo().getControlGroup().equals("E") && !this.importExternal || v.getDatastreamInfo().getControlGroup().equals("R") && !this.importRedirect) {
                        this.f4client.createOrUpdateRedirectNonRDFResource(dsPath, this.externalContentUrlMapper.mapURL(v.getExternalOrRedirectURL()));
                        this.updateDatastreamProperties(version2.getObject(), v, dsPath);
                        continue;
                    }
                    this.f4client.createOrUpdateNonRDFResource(dsPath, v.getContent(), v.getMimeType());
                    this.updateDatastreamProperties(version2.getObject(), v, dsPath);
                }
                this.updateObjectProperties(version2, objectPath, triplesToRemove, triplesToInsert);
                this.f4client.createVersionSnapshot(objectPath, "imported-version-" + String.valueOf(version2.getVersionIndex()));
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private List<DatastreamVersion> withRELSINTLast(List<DatastreamVersion> orig) {
        ArrayList<DatastreamVersion> versionsWithRELSINTLast = new ArrayList<DatastreamVersion>(orig);
        for (int i = 0; i < versionsWithRELSINTLast.size(); ++i) {
            if (!((DatastreamVersion)versionsWithRELSINTLast.get(i)).getDatastreamInfo().getDatastreamId().equals("RELS-INT")) continue;
            versionsWithRELSINTLast.add((DatastreamVersion)versionsWithRELSINTLast.remove(i));
            break;
        }
        return versionsWithRELSINTLast;
    }

    protected boolean isDateProperty(String uri) {
        return uri.equals("info:fedora/fedora-system:def/model#createdDate") || uri.equals("info:fedora/fedora-system:def/view#lastModifiedDate") || uri.equals("http://www.loc.gov/premis/rdf/v1#hasDateCreatedByApplication") || uri.equals("http://www.loc.gov/premis/rdf/v1#hasEventDateTime");
    }

    protected void updateObjectProperties(ObjectVersionReference version2, String objectPath, QuadAcc triplesToRemove, QuadDataAcc triplesToInsert) {
        if (version2.isFirstVersion()) {
            String now2 = this.getCurrentTimeInXSDDateTime();
            if (now2 != null) {
                this.addDateEvent(triplesToInsert, "http://id.loc.gov/vocabulary/preservation/eventType/mig", this.getCurrentTimeInXSDDateTime());
            }
            this.mapProperty("info:fedora/fedora-system:def/model#PID", version2.getObject().getObjectInfo().getPid(), triplesToRemove, triplesToInsert, true);
        }
        if (version2.isLastVersion()) {
            for (ObjectProperty objectProperty : version2.getObjectProperties().listProperties()) {
                this.mapProperty(objectProperty.getName(), objectProperty.getValue(), triplesToRemove, triplesToInsert, true);
            }
        }
        if (!triplesToInsert.getQuads().isEmpty() && !triplesToRemove.getQuads().isEmpty()) {
            this.updateResourceProperties(objectPath, triplesToRemove, triplesToInsert, false);
        }
    }

    protected void mapProperty(String origPred, String obj, QuadAcc triplesToRemove, QuadDataAcc triplesToInsert, Boolean isLiteral) {
        String pred = origPred;
        if (this.customPropertyMapping != null && this.customPropertyMapping.containsKey(pred)) {
            pred = this.customPropertyMapping.getProperty(pred);
        } else {
            if (pred.equals("info:fedora/fedora-system:def/model#createdDate")) {
                this.updateDateTriple(triplesToRemove, triplesToInsert, "http://fedora.info/definitions/v4/repository#created", obj);
                return;
            }
            if (pred.equals("info:fedora/fedora-system:def/view#lastModifiedDate")) {
                this.updateDateTriple(triplesToRemove, triplesToInsert, "http://fedora.info/definitions/v4/repository#lastModified", obj);
                return;
            }
        }
        if (this.isDateProperty(origPred)) {
            this.updateDateTriple(triplesToRemove, triplesToInsert, pred, obj);
        } else if (isLiteral.booleanValue()) {
            this.updateLiteralTriple(triplesToRemove, triplesToInsert, pred, obj);
        } else {
            this.updateUriTriple(triplesToRemove, triplesToInsert, pred, obj);
        }
    }

    protected void updateDatastreamProperties(ObjectReference obj, DatastreamVersion v, String dsPath) {
        QuadDataAcc triplesToInsert = new QuadDataAcc();
        QuadAcc triplesToRemove = new QuadAcc();
        String createdDate = v.getCreated();
        if (v.isFirstVersionIn(obj)) {
            String now2 = this.getCurrentTimeInXSDDateTime();
            if (now2 != null) {
                this.addDateEvent(triplesToInsert, "http://id.loc.gov/vocabulary/preservation/eventType/mig", this.getCurrentTimeInXSDDateTime());
            }
            if (createdDate != null) {
                LOGGER.debug("Setting created date to " + createdDate + "...");
                this.updateDateTriple(triplesToRemove, triplesToInsert, "http://fedora.info/definitions/v4/repository#created", createdDate);
            }
        }
        if (v.isLastVersionIn(obj)) {
            String formatUri;
            String state;
            String label;
            String dsid = v.getDatastreamInfo().getDatastreamId();
            if (dsid != null) {
                this.updateLiteralTriple(triplesToRemove, triplesToInsert, "http://purl.org/dc/terms/identifier", dsid);
            }
            if (createdDate != null) {
                this.updateDateTriple(triplesToRemove, triplesToInsert, "http://fedora.info/definitions/v4/repository#lastModified", createdDate);
            }
            if ((label = v.getLabel()) != null) {
                this.updateLiteralTriple(triplesToRemove, triplesToInsert, "http://purl.org/dc/terms/title", label);
            }
            if ((state = v.getDatastreamInfo().getState()) != null) {
                this.updateLiteralTriple(triplesToRemove, triplesToInsert, "http://fedora.info/definitions/1/0/access/objState", state);
            }
            if ((formatUri = v.getFormatUri()) != null) {
                this.updateLiteralTriple(triplesToRemove, triplesToInsert, "http://www.loc.gov/premis/rdf/v1#formatDesignation", formatUri);
            }
        }
        if (!triplesToInsert.getQuads().isEmpty() && !triplesToRemove.getQuads().isEmpty()) {
            this.updateResourceProperties(dsPath, triplesToRemove, triplesToInsert, true);
        }
    }

    protected void migrateRelsExt(DatastreamVersion v, QuadAcc triplesToRemove, QuadDataAcc triplesToInsert) throws IOException {
        String objectUri = "info:fedora/" + v.getDatastreamInfo().getObjectInfo().getPid();
        Model m3 = ModelFactory.createDefaultModel();
        m3.read(v.getContent(), null);
        StmtIterator statementIt = m3.listStatements();
        while (statementIt.hasNext()) {
            Statement s2 = statementIt.nextStatement();
            if (s2.getSubject().getURI().equals(objectUri)) {
                String predicateUri = s2.getPredicate().getURI();
                if (s2.getObject().isLiteral()) {
                    this.mapProperty(predicateUri, s2.getObject().asLiteral().getString(), triplesToRemove, triplesToInsert, true);
                    continue;
                }
                if (s2.getObject().isURIResource()) {
                    this.mapProperty(predicateUri, s2.getObject().asResource().getURI(), triplesToRemove, triplesToInsert, false);
                    continue;
                }
                throw new RuntimeException("No current handling for non-URI, non-Literal subjects in Fedora RELS-INT.");
            }
            throw new RuntimeException("Non-resource subject found: " + s2.getSubject().getURI());
        }
    }

    protected void migrateRelsInt(DatastreamVersion v) throws IOException, RuntimeException {
        Model m3 = ModelFactory.createDefaultModel();
        m3.read(v.getContent(), null);
        StmtIterator statementIt = m3.listStatements();
        while (statementIt.hasNext()) {
            Statement s2 = statementIt.nextStatement();
            String dsUri = s2.getSubject().getURI();
            String[] splitUri = dsUri.split("/");
            String dsId = splitUri[splitUri.length - 1];
            String dsPath = this.idMapper.mapDatastreamPath(v.getDatastreamInfo().getObjectInfo().getPid(), dsId);
            if (!this.f4client.exists(dsPath)) {
                this.f4client.createNonRDFPlaceholder(dsPath);
                LOGGER.warn("The datastream \"" + dsId + "\" referenced in the RDF datastream \"" + v.getDatastreamInfo().getDatastreamId() + "\" on " + v.getDatastreamInfo().getObjectInfo().getPid() + " did not exist at " + v.getCreated() + ", making a placeholder!");
            }
            QuadDataAcc triplesToInsert = new QuadDataAcc();
            QuadAcc triplesToRemove = new QuadAcc();
            String pred = s2.getPredicate().getURI();
            if (s2.getObject().isLiteral()) {
                this.mapProperty(pred, s2.getObject().asLiteral().getString(), triplesToRemove, triplesToInsert, true);
            } else if (s2.getObject().isURIResource()) {
                this.mapProperty(pred, s2.getObject().asResource().getURI(), triplesToRemove, triplesToInsert, false);
            } else {
                throw new RuntimeException("No current handling for non-URI, non-Literal subjects in Fedora RELS-INT.");
            }
            this.updateResourceProperties(dsPath, triplesToRemove, triplesToInsert, true);
        }
    }

    protected void migrateDc(DatastreamVersion v, QuadAcc triplesToRemove, QuadDataAcc triplesToInsert) throws IOException, RuntimeException {
        try {
            DC dc = DC.parseDC(v.getContent());
            for (String uri : dc.getRepresentedElementURIs()) {
                triplesToRemove.addTriple(new Triple(NodeFactory.createURI(""), NodeFactory.createURI(uri), NodeFactory.createVariable("o")));
                for (String value : dc.getValuesForURI(uri)) {
                    triplesToInsert.addTriple(new Triple(NodeFactory.createURI(""), NodeFactory.createURI(uri), NodeFactory.createLiteral(value)));
                    LOGGER.debug("Adding " + uri + " value " + value);
                }
            }
        }
        catch (JAXBException e2) {
            throw new RuntimeException("Error parsing DC datastream " + v.getVersionId());
        }
    }

    protected void updateResourceProperties(String path, QuadAcc triplesToRemove, QuadDataAcc triplesToInsert, boolean isNonRDF) throws RuntimeException {
        try {
            UpdateRequest updateRequest = UpdateFactory.create();
            this.namespacePrefixMapper.setPrefixes(updateRequest);
            updateRequest.add(new UpdateDeleteWhere(triplesToRemove));
            updateRequest.add(new UpdateDataInsert(triplesToInsert));
            ByteArrayOutputStream sparqlUpdate = new ByteArrayOutputStream();
            updateRequest.output(new IndentedWriter(sparqlUpdate));
            LOGGER.trace("SPARQL: " + sparqlUpdate.toString("UTF-8"));
            if (isNonRDF) {
                this.f4client.updateNonRDFResourceProperties(path, sparqlUpdate.toString("UTF-8"));
            } else {
                this.f4client.updateResourceProperties(path, sparqlUpdate.toString("UTF-8"));
            }
            suffix = 0;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected void updateLiteralTriple(QuadAcc triplesToRemove, QuadDataAcc triplesToInsert, String predicate, String object) {
        triplesToRemove.addTriple(new Triple(NodeFactory.createURI(""), NodeFactory.createURI(predicate), NodeFactory.createVariable("o" + String.valueOf(suffix))));
        triplesToInsert.addTriple(new Triple(NodeFactory.createURI(""), NodeFactory.createURI(predicate), NodeFactory.createLiteral(object)));
        ++suffix;
    }

    protected void updateUriTriple(QuadAcc triplesToRemove, QuadDataAcc triplesToInsert, String predicate, String object) {
        String newObjectUri = this.resolveInternalURI(object);
        triplesToRemove.addTriple(new Triple(NodeFactory.createURI(""), NodeFactory.createURI(predicate), NodeFactory.createVariable("o" + String.valueOf(suffix))));
        triplesToInsert.addTriple(new Triple(NodeFactory.createURI(""), NodeFactory.createURI(predicate), NodeFactory.createURI(newObjectUri)));
        ++suffix;
    }

    protected String resolveInternalURI(String uri) {
        if (uri.startsWith("info:fedora/")) {
            String path = this.idMapper.mapObjectPath(uri.substring("info:fedora/".length()));
            this.f4client.createPlaceholder(path);
            return this.f4client.getRepositoryUrl() + path;
        }
        return uri;
    }

    protected void updateDateTriple(QuadAcc triplesToRemove, QuadDataAcc triplesToInsert, String predicate, String object) {
        triplesToRemove.addTriple(new Triple(NodeFactory.createURI(""), NodeFactory.createURI(predicate), NodeFactory.createVariable("o" + String.valueOf(suffix))));
        triplesToInsert.addTriple(new Triple(NodeFactory.createURI(""), NodeFactory.createURI(predicate), NodeFactory.createLiteral(object, XSDDatatype.XSDdateTime)));
        ++suffix;
    }

    protected void addDateEvent(QuadDataAcc triplesToInsert, String eventTypeURI, String object) {
        String eventPred = "http://www.loc.gov/premis/rdf/v1#hasEvent";
        String eventTypePred = "http://www.loc.gov/premis/rdf/v1#hasEventType";
        String eventDatePred = "http://www.loc.gov/premis/rdf/v1#hasEventDateTime";
        Node bnode2 = NodeFactory.createAnon();
        triplesToInsert.addTriple(new Triple(NodeFactory.createURI(""), NodeFactory.createURI("http://www.loc.gov/premis/rdf/v1#hasEvent"), bnode2));
        triplesToInsert.addTriple(new Triple(bnode2, NodeFactory.createURI("http://www.loc.gov/premis/rdf/v1#hasEventType"), NodeFactory.createURI(eventTypeURI)));
        triplesToInsert.addTriple(new Triple(bnode2, NodeFactory.createURI("http://www.loc.gov/premis/rdf/v1#hasEventDateTime"), NodeFactory.createLiteral(object, XSDDatatype.XSDdateTime)));
    }

    protected String getCurrentTimeInXSDDateTime() {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new Date());
            XMLGregorianCalendar now2 = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
            return now2.toString();
        }
        catch (DatatypeConfigurationException e2) {
            LOGGER.error("Error converting date object to proper format!", e2);
            return null;
        }
    }
}

