/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.idmappers;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.FSDirectory;
import org.fcrepo.migration.Fedora4Client;
import org.fcrepo.migration.MigrationIDMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpaqueIDMapper
implements MigrationIDMapper {
    private static final Logger ID_LOGGER = LoggerFactory.getLogger("id-mapper");
    private static final Logger LOGGER = LoggerFactory.getLogger(OpaqueIDMapper.class);
    private Fedora4Client f4Client;
    private SearcherManager searcherManager;
    private IndexWriter writer;

    public OpaqueIDMapper(File cachedIDIndexDir, Fedora4Client f4Client) throws IOException {
        File indexDir;
        this.f4Client = f4Client;
        if (cachedIDIndexDir == null) {
            File temp = File.createTempFile("tempfile", "basedir");
            temp.delete();
            temp.mkdir();
            indexDir = new File(temp, "index");
            LOGGER.info("No generated ID index directory specified.  Creating temporary index at \"" + indexDir.getAbsolutePath() + "\".");
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        OpaqueIDMapper.this.searcherManager.close();
                        OpaqueIDMapper.this.writer.close();
                        OpaqueIDMapper.this.writer.getDirectory().close();
                        LOGGER.info("Deleting generated ID index directory at \"" + indexDir.getAbsolutePath() + "\"...");
                        FileUtils.deleteDirectory(indexDir);
                    }
                    catch (IOException e2) {
                        LOGGER.error("Unable to delete generated ID index directory at \"" + indexDir.getAbsolutePath() + "\"!", e2);
                        e2.printStackTrace();
                    }
                }
            }));
        } else {
            indexDir = cachedIDIndexDir;
        }
        FSDirectory dir = FSDirectory.open(indexDir.toPath());
        if (indexDir.exists()) {
            LOGGER.warn("Index exists at \"" + indexDir.getPath() + "\" and will be used.  To clear index, simply delete this directory and re-run the application.");
        }
        StandardAnalyzer analyzer = new StandardAnalyzer();
        IndexWriterConfig iwc = new IndexWriterConfig(analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        this.writer = new IndexWriter(dir, iwc);
        this.writer.commit();
        this.searcherManager = new SearcherManager(this.writer, false, false, null);
    }

    @Override
    public String mapObjectPath(String pid) {
        String cachedPath = this.getCachedObjectPath(pid);
        if (cachedPath != null) {
            return cachedPath;
        }
        String path = this.f4Client.createPlaceholder(null);
        this.cacheObjectPath(pid, path);
        return path;
    }

    @Override
    public String mapDatastreamPath(String pid, String dsid) {
        String cachedObjectPath = this.getCachedObjectPath(pid);
        if (cachedObjectPath != null) {
            return cachedObjectPath + "/" + dsid;
        }
        String path = this.f4Client.createPlaceholder(null);
        this.cacheObjectPath(pid, path);
        return path + "/" + dsid;
    }

    @Override
    public String getBaseURL() {
        return this.f4Client.getRepositoryUrl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCachedObjectPath(String pid) {
        try {
            IndexSearcher s2 = (IndexSearcher)this.searcherManager.acquire();
            try {
                TopDocs result = s2.search((Query)new TermQuery(new Term("pid", pid)), 2);
                LOGGER.trace("Found " + result.totalHits + " hit(s) for pid=" + pid);
                if (result.totalHits == 1L) {
                    String string = s2.doc(result.scoreDocs[0].doc).get("path");
                    return string;
                }
                if (result.totalHits >= 1L) throw new IllegalStateException(result.totalHits + " paths registered for the pid \"" + pid + "\".  (" + s2.doc(result.scoreDocs[0].doc).get("path") + ", " + s2.doc(result.scoreDocs[1].doc).get("path") + "...)");
                String string = null;
                return string;
            }
            finally {
                this.searcherManager.release(s2);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void cacheObjectPath(String pid, String path) {
        ID_LOGGER.info(pid + " --> " + this.f4Client.getRepositoryUrl() + path);
        try {
            Document doc = new Document();
            doc.add(new StringField("path", path, Field.Store.YES));
            doc.add(new StringField("pid", pid, Field.Store.YES));
            LOGGER.trace("Added \"" + pid + "\" --> \"" + path + "\" to ID cache.");
            this.writer.addDocument(doc);
            this.writer.commit();
            this.searcherManager.maybeRefreshBlocking();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

