/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.Arg;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgProc;
import arq.cmdline.CommandLineBase;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;

public class CmdLineArgs
extends CommandLineBase {
    private boolean processedArgs = false;
    protected Map<String, ArgDecl> argMap = new HashMap<String, ArgDecl>();
    protected Map<String, Arg> args = new HashMap<String, Arg>();
    protected List<String> positionals = new ArrayList<String>();
    static final String DefaultIndirectMarker = "@";

    public CmdLineArgs(String[] args) {
        super(args);
    }

    public void process() throws IllegalArgumentException {
        this.processedArgs = true;
        this.apply(new ArgProcessor());
    }

    public CmdLineArgs add(String argName, boolean hasValue) {
        return this.add(new ArgDecl(hasValue, argName, new String[0]));
    }

    public CmdLineArgs add(boolean hasValue, String argName) {
        return this.add(new ArgDecl(hasValue, argName, new String[0]));
    }

    public CmdLineArgs add(ArgDecl arg) {
        Iterator<String> iter = arg.names();
        while (iter.hasNext()) {
            String name = iter.next();
            if (this.argMap.containsKey(name)) {
                Log.warn(this, "Argument '" + name + "' already added");
            }
            this.argMap.put(name, arg);
        }
        return this;
    }

    public CmdLineArgs addPositional(String value) {
        this.positionals.add(value);
        return this;
    }

    public CmdLineArgs addArg(String name) {
        return this.addArg(name, null);
    }

    public CmdLineArgs addArg(String name, String value) {
        if (!this.args.containsKey(name)) {
            this.args.put(name, new Arg(name));
        }
        Arg arg = this.args.get(name);
        return this.addArgWorker(arg, value);
    }

    private CmdLineArgs addArgWorker(Arg arg, String value) {
        ArgDecl argDecl = this.argMap.get(arg.name);
        if (!argDecl.takesValue() && value != null) {
            throw new IllegalArgumentException("No value for argument: " + arg.getName());
        }
        if (argDecl.takesValue()) {
            if (value == null) {
                throw new IllegalArgumentException("No value for argument: " + arg.getName());
            }
            arg.setValue(value);
            arg.addValue(value);
        }
        return this;
    }

    public boolean matchesIndirect(String s2) {
        return this.matchesIndirect(s2, DefaultIndirectMarker);
    }

    public boolean matchesIndirect(String s2, String marker) {
        return s2.startsWith(marker);
    }

    public String indirect(String s2) {
        return this.indirect(s2, DefaultIndirectMarker);
    }

    public String indirect(String s2, String marker) {
        if (!this.matchesIndirect(s2, marker)) {
            return s2;
        }
        s2 = s2.substring(marker.length());
        s2 = FileManager.get().readWholeFileAsUTF8(s2);
        return s2;
    }

    public boolean contains(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public boolean contains(String s2) {
        return this.getArg(s2) != null;
    }

    public boolean containsMultiple(String s2) {
        return this.getValues(s2).size() > 1;
    }

    public boolean containsMultiple(ArgDecl argDecl) {
        return this.getValues(argDecl).size() > 1;
    }

    public boolean hasArgs() {
        return this.args.size() > 0;
    }

    public boolean hasArg(String argName) {
        return this.getArg(argName) != null;
    }

    public boolean hasArg(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public Arg getArg(ArgDecl argDecl) {
        Arg arg = null;
        for (Arg a : this.args.values()) {
            if (!argDecl.matches(a)) continue;
            arg = a;
        }
        return arg;
    }

    public Arg getArg(String argName) {
        argName = ArgDecl.canonicalForm(argName);
        return this.args.get(argName);
    }

    public String getValue(ArgDecl argDecl) {
        Arg arg = this.getArg(argDecl);
        if (arg == null) {
            return null;
        }
        if (arg.hasValue()) {
            return arg.getValue();
        }
        return null;
    }

    public String getValue(String argName) {
        Arg arg = this.getArg(argName);
        if (arg == null) {
            return null;
        }
        return arg.getValue();
    }

    public boolean hasValueOfTrue(ArgDecl argDecl) {
        String x = this.getValue(argDecl);
        if (x == null) {
            return false;
        }
        return x.equalsIgnoreCase("true") || x.equalsIgnoreCase("t") || x.equalsIgnoreCase("yes") || x.equalsIgnoreCase("y");
    }

    public boolean hasValueOfFalse(ArgDecl argDecl) {
        String x = this.getValue(argDecl);
        if (x == null) {
            return false;
        }
        return x.equalsIgnoreCase("false") || x.equalsIgnoreCase("f") || x.equalsIgnoreCase("no") || x.equalsIgnoreCase("n");
    }

    public List<String> getValues(ArgDecl argDecl) {
        Arg arg = this.getArg(argDecl);
        if (arg == null) {
            return new ArrayList<String>();
        }
        return arg.getValues();
    }

    public List<String> getValues(String argName) {
        Arg arg = this.getArg(argName);
        if (arg == null) {
            return new ArrayList<String>();
        }
        return arg.getValues();
    }

    public String getPositionalArg(int i) {
        return this.positionals.get(i);
    }

    public int getNumPositional() {
        return this.positionals.size();
    }

    public boolean hasPositional() {
        return this.positionals.size() > 0;
    }

    public List<String> getPositional() {
        return this.positionals;
    }

    public List<String> getPositionalOrStdin() {
        if (!this.positionals.isEmpty()) {
            return Collections.unmodifiableList(this.positionals);
        }
        List<String> x = Arrays.asList("-");
        return Collections.unmodifiableList(x);
    }

    protected void handleUnrecognizedArg(String argStr) {
        throw new CmdException("Unknown argument: " + argStr);
    }

    private ArgDecl find(String a) {
        a = ArgDecl.canonicalForm(a);
        return this.argMap.get(a);
    }

    public String toString() {
        if (!this.processedArgs) {
            return super.toString();
        }
        String str2 = "";
        String sep = "";
        for (String k : this.args.keySet()) {
            Arg a = this.args.get(k);
            str2 = str2 + sep + a;
            sep = " ";
        }
        sep = " -- ";
        for (String v : this.positionals) {
            str2 = str2 + sep + v;
            sep = " ";
        }
        return str2;
    }

    class ArgProcessor
    implements ArgProc {
        boolean nextArgProcessed = false;
        boolean positionalArgsStarted = false;

        ArgProcessor() {
        }

        @Override
        public void startArgs() {
            this.nextArgProcessed = false;
            this.positionalArgsStarted = false;
        }

        @Override
        public void finishArgs() {
        }

        @Override
        public void arg(String argStr, int i) {
            if (this.nextArgProcessed) {
                this.nextArgProcessed = false;
                return;
            }
            if (this.positionalArgsStarted) {
                CmdLineArgs.this.addPositional(argStr);
                return;
            }
            if (argStr.equals("-") || argStr.equals("--")) {
                this.positionalArgsStarted = true;
                return;
            }
            if (!argStr.startsWith("-")) {
                this.positionalArgsStarted = true;
                CmdLineArgs.this.addPositional(argStr);
                return;
            }
            if (!CmdLineArgs.this.argMap.containsKey(argStr = ArgDecl.canonicalForm(argStr))) {
                CmdLineArgs.this.handleUnrecognizedArg(argStr);
                return;
            }
            ArgDecl argDecl = CmdLineArgs.this.argMap.get(argStr);
            if (argDecl.takesValue()) {
                String val = CmdLineArgs.this.getArg(i + 1);
                String x = argDecl.getKeyName();
                CmdLineArgs.this.addArg(x, val);
                this.nextArgProcessed = true;
            } else {
                CmdLineArgs.this.addArg(argStr);
            }
        }
    }
}

