/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler;

import com.hp.hpl.jena.assembler.exceptions.AssemblerException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;

public class BadObjectException
extends AssemblerException {
    protected final RDFNode object;

    public BadObjectException(Statement s2) {
        super(s2.getSubject(), BadObjectException.makeMessage(s2));
        this.object = s2.getObject();
    }

    private static String makeMessage(Statement s2) {
        RDFNode subject = s2.getObject();
        return "the " + BadObjectException.typeOf(subject) + " " + BadObjectException.nice(subject) + " is unsuitable as the object of a " + BadObjectException.nice(s2.getPredicate()) + " statement";
    }

    private static String typeOf(RDFNode x) {
        return x.isAnon() ? "bnode" : (x.isLiteral() ? "literal" : "resource");
    }

    public RDFNode getObject() {
        return this.object;
    }
}

