/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import java.util.Iterator;

public class AllDifferentImpl
extends OntResourceImpl
implements AllDifferent {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new AllDifferentImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to AllDifferent");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile2 = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile2 != null && profile2.isSupported(node, eg, AllDifferent.class);
        }
    };

    public AllDifferentImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setDistinctMembers(RDFList members) {
        this.setPropertyValue(this.getProfile().DISTINCT_MEMBERS(), "DISTINCT_MEMBERS", members);
    }

    @Override
    public void addDistinctMember(Resource res) {
        this.addListPropertyValue(this.getProfile().DISTINCT_MEMBERS(), "DISTINCT_MEMBERS", res);
    }

    @Override
    public void addDistinctMembers(Iterator<? extends Resource> individuals) {
        while (individuals.hasNext()) {
            this.addDistinctMember(individuals.next());
        }
    }

    @Override
    public RDFList getDistinctMembers() {
        return this.objectAs(this.getProfile().DISTINCT_MEMBERS(), "DISTINCT_MEMBERS", RDFList.class);
    }

    @Override
    public ExtendedIterator<? extends OntResource> listDistinctMembers() {
        return this.getDistinctMembers().mapWith(new Map1<RDFNode, OntResource>(){

            @Override
            public OntResource map1(RDFNode o) {
                return ((Resource)o).as(OntResource.class);
            }
        });
    }

    @Override
    public boolean hasDistinctMember(Resource res) {
        return this.getDistinctMembers().contains(res);
    }

    @Override
    public void removeDistinctMember(Resource res) {
        this.setDistinctMembers(this.getDistinctMembers().remove(res));
    }
}

