/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.RestrictionImpl;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;

public class HasValueRestrictionImpl
extends RestrictionImpl
implements HasValueRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new HasValueRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to HasValueRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile2 = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile2 != null && profile2.isSupported(node, eg, HasValueRestriction.class);
        }
    };

    public HasValueRestrictionImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setHasValue(RDFNode value) {
        this.setPropertyValue(this.getProfile().HAS_VALUE(), "HAS_VALUE", value);
    }

    @Override
    public RDFNode getHasValue() {
        this.checkProfile(this.getProfile().HAS_VALUE(), "HAS_VALUE");
        RDFNode n = this.getPropertyValue(this.getProfile().HAS_VALUE());
        if (!(n instanceof Literal) && n.canAs(Individual.class)) {
            n = n.as(Individual.class);
        }
        return n;
    }

    @Override
    public boolean hasValue(RDFNode value) {
        return this.hasPropertyValue(this.getProfile().HAS_VALUE(), "HAS_VALUE", value);
    }

    @Override
    public void removeHasValue(RDFNode value) {
        this.removePropertyValue(this.getProfile().HAS_VALUE(), "HAS_VALUE", value);
    }
}

