/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.AbstractProfile;
import com.hp.hpl.jena.ontology.impl.BooleanClassDescriptionImpl;
import com.hp.hpl.jena.rdf.model.Property;

public class IntersectionClassImpl
extends BooleanClassDescriptionImpl
implements IntersectionClass {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new IntersectionClassImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to IntersectionClass");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile2 = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile2 != null && profile2.isSupported(node, eg, OntClass.class) && AbstractProfile.containsSome(eg, node, profile2.INTERSECTION_OF());
        }
    };

    public IntersectionClassImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public Property operator() {
        return this.getProfile().INTERSECTION_OF();
    }

    @Override
    public String getOperatorName() {
        return "INTERSECTION_OF";
    }
}

