/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdfxml.xmlinput;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdfxml.xmlinput.ALiteral;
import com.hp.hpl.jena.rdfxml.xmlinput.ARPHandlers;
import com.hp.hpl.jena.rdfxml.xmlinput.AResource;
import com.hp.hpl.jena.rdfxml.xmlinput.JenaReader;
import com.hp.hpl.jena.rdfxml.xmlinput.NamespaceHandler;
import com.hp.hpl.jena.rdfxml.xmlinput.StatementHandler;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.ARPSaxErrorHandler;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;

final class JenaHandler
extends ARPSaxErrorHandler
implements StatementHandler,
NamespaceHandler {
    private final PrefixMapping prefixMapping;
    protected int here = 0;
    private final Graph graph;

    public JenaHandler(Model m3, RDFErrorHandler e2) {
        this(m3.getGraph(), e2);
    }

    public JenaHandler(Graph g2, Model m3, RDFErrorHandler e2) {
        this(g2, JenaHandler.modelToPrefixMapping(m3), e2);
    }

    private JenaHandler(Graph graph, RDFErrorHandler e2) {
        this(graph, graph.getPrefixMapping(), e2);
    }

    private JenaHandler(Graph graph, PrefixMapping prefixMapping, RDFErrorHandler errorHandler) {
        super(errorHandler);
        this.graph = graph;
        this.prefixMapping = prefixMapping;
    }

    private static PrefixMapping modelToPrefixMapping(Model model) {
        return model == null ? PrefixMapping.Factory.create() : model.getGraph().getPrefixMapping();
    }

    public void useWith(ARPHandlers h2) {
        h2.setStatementHandler(this);
        h2.setErrorHandler(this);
        h2.setNamespaceHandler(this);
    }

    @Override
    public void statement(AResource subj, AResource pred, AResource obj) {
        try {
            Triple t = JenaReader.convert(subj, pred, obj);
            this.graph.add(t);
        }
        catch (JenaException e2) {
            this.errorHandler.error(e2);
        }
    }

    @Override
    public void statement(AResource subj, AResource pred, ALiteral lit) {
        try {
            Triple t = JenaReader.convert(subj, pred, lit);
            this.graph.add(t);
        }
        catch (JenaException e2) {
            this.errorHandler.error(e2);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (PrefixMappingImpl.isNiceURI(uri)) {
            this.prefixMapping.setNsPrefix(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }
}

