/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.util.PrintUtil;
import java.util.ArrayList;

public class BindingVector
implements BindingEnvironment {
    protected Node[] environment;

    public BindingVector(int size) {
        this.environment = new Node[size];
    }

    public BindingVector(Node[] env) {
        this.environment = env;
    }

    public BindingVector(BindingVector clone) {
        Node[] orig = clone.environment;
        this.environment = new Node[orig.length];
        System.arraycopy(orig, 0, this.environment, 0, orig.length);
    }

    public Node[] getEnvironment() {
        return this.environment;
    }

    public Node getBinding(Node node) {
        if (node instanceof Node_RuleVariable) {
            Node val = this.environment[((Node_RuleVariable)node).getIndex()];
            if (val instanceof Node_RuleVariable) {
                return this.getBinding(val);
            }
            return val;
        }
        if (node instanceof Node_ANY) {
            return null;
        }
        if (Functor.isFunctor(node)) {
            Functor functor = (Functor)node.getLiteralValue();
            if (functor.isGround()) {
                return node;
            }
            Node[] args = functor.getArgs();
            ArrayList<Node> boundargs = new ArrayList<Node>(args.length);
            for (Node arg : args) {
                Node binding = this.getBinding(arg);
                if (binding == null) {
                    return null;
                }
                boundargs.add(binding);
            }
            Functor newf = new Functor(functor.getName(), boundargs);
            return Functor.makeFunctorNode(newf);
        }
        return node;
    }

    @Override
    public Node getGroundVersion(Node node) {
        Node bind = this.getBinding(node);
        if (bind == null) {
            return node;
        }
        return bind;
    }

    public boolean bind(int i, Node value) {
        Node node = this.environment[i];
        if (node == null) {
            this.environment[i] = value;
            return true;
        }
        if (node instanceof Node_RuleVariable) {
            this.environment[i] = value;
            return this.bind(((Node_RuleVariable)node).getIndex(), value);
        }
        return node.sameValueAs(value);
    }

    @Override
    public boolean bind(Node var, Node value) {
        if (var instanceof Node_RuleVariable) {
            return this.bind(((Node_RuleVariable)var).getIndex(), value);
        }
        return var.sameValueAs(value);
    }

    public TriplePattern partInstantiate(TriplePattern goal) {
        return new TriplePattern(this.getGroundVersion(goal.getSubject()), this.getGroundVersion(goal.getPredicate()), this.getGroundVersion(goal.getObject()));
    }

    @Override
    public Triple instantiate(TriplePattern pattern) {
        Node o;
        Node p;
        Node s2 = this.getGroundVersion(pattern.getSubject());
        if (s2.isVariable()) {
            s2 = NodeFactory.createAnon();
        }
        if ((p = this.getGroundVersion(pattern.getPredicate())).isVariable()) {
            p = NodeFactory.createAnon();
        }
        if ((o = this.getGroundVersion(pattern.getObject())).isVariable()) {
            o = NodeFactory.createAnon();
        }
        return new Triple(s2, p, o);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Node anEnvironment : this.environment) {
            if (anEnvironment == null) {
                buffer.append("-");
            } else {
                buffer.append(PrintUtil.print(anEnvironment));
            }
            buffer.append(" ");
        }
        return buffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static BindingVector unify(TriplePattern goal, TriplePattern head, int numRuleVars) {
        Node[] hArgs;
        Node[] gArgs;
        Node[] hEnv;
        Node[] gEnv;
        block11: {
            Node hObj;
            Node gObj;
            block10: {
                gEnv = new Node[numRuleVars];
                hEnv = new Node[numRuleVars];
                if (!BindingVector.unify(goal.getSubject(), head.getSubject(), gEnv, hEnv)) {
                    return null;
                }
                if (!BindingVector.unify(goal.getPredicate(), head.getPredicate(), gEnv, hEnv)) {
                    return null;
                }
                gObj = goal.getObject();
                hObj = head.getObject();
                if (!Functor.isFunctor(gObj)) break block10;
                Functor gFunctor = (Functor)gObj.getLiteralValue();
                if (Functor.isFunctor(hObj)) {
                    Functor hFunctor = (Functor)hObj.getLiteralValue();
                    if (!gFunctor.getName().equals(hFunctor.getName())) {
                        return null;
                    }
                    gArgs = gFunctor.getArgs();
                    if (gArgs.length != (hArgs = hFunctor.getArgs()).length) {
                        return null;
                    }
                    break block11;
                } else {
                    if (!(hObj instanceof Node_RuleVariable)) {
                        return null;
                    }
                    if (!gFunctor.isGround(new BindingVector(gEnv)) || BindingVector.unify(gObj, hObj, gEnv, hEnv)) return new BindingVector(hEnv);
                    return null;
                }
            }
            if (BindingVector.unify(gObj, hObj, gEnv, hEnv)) return new BindingVector(hEnv);
            return null;
        }
        for (int i = 0; i < gArgs.length; ++i) {
            if (BindingVector.unify(gArgs[i], hArgs[i], gEnv, hEnv)) continue;
            return null;
        }
        return new BindingVector(hEnv);
    }

    private static boolean unify(Node gNode, Node hNode, Node[] gEnv, Node[] hEnv) {
        if (hNode instanceof Node_RuleVariable) {
            int hIndex = ((Node_RuleVariable)hNode).getIndex();
            if (gNode instanceof Node_RuleVariable) {
                int gIndex = ((Node_RuleVariable)gNode).getIndex();
                if (gIndex < 0) {
                    return true;
                }
                if (gEnv[gIndex] == null) {
                    gEnv[gIndex] = hNode;
                } else {
                    Node gVal = gEnv[gIndex];
                    if (hIndex != gIndex || !(gVal instanceof Node_RuleVariable)) {
                        hEnv[hIndex] = gVal;
                    }
                }
            } else {
                Node hVal = hEnv[hIndex];
                if (hVal == null) {
                    hEnv[hIndex] = gNode;
                } else if (hVal instanceof Node_RuleVariable) {
                    hEnv[((Node_RuleVariable)hVal).getIndex()] = gNode;
                    hEnv[hIndex] = gNode;
                } else {
                    return hVal.sameValueAs(gNode);
                }
            }
            return true;
        }
        if (gNode instanceof Node_RuleVariable) {
            int gIndex = ((Node_RuleVariable)gNode).getIndex();
            if (gIndex < 0) {
                return true;
            }
            Node gVal = gEnv[gIndex];
            if (gVal == null) {
                gEnv[gIndex] = hNode;
            } else if (gVal instanceof Node_RuleVariable) {
                hEnv[((Node_RuleVariable)gVal).getIndex()] = hNode;
                gEnv[gIndex] = hNode;
            } else {
                return gVal.sameValueAs(hNode);
            }
            return true;
        }
        return hNode.sameValueAs(gNode);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BindingVector)) {
            return false;
        }
        Node[] other = ((BindingVector)o).environment;
        if (this.environment.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.environment.length; ++i) {
            Node n = this.environment[i];
            Node no = other[i];
            if (!(n == null ? no != null : !n.sameValueAs(no))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (Node n : this.environment) {
            hash = hash << 1 ^ (n == null ? 21372 : n.hashCode());
        }
        return hash;
    }
}

