/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.http;

public class HttpContentType {
    String mediaType = null;
    String[] params = null;
    String charset = null;

    public HttpContentType(String s2) {
        this.parse(s2);
    }

    public HttpContentType(String s2, String defaultMediaType, String defaultCharset) {
        this(s2);
        if (this.mediaType == null) {
            this.mediaType = defaultMediaType;
        }
        if (this.charset == null) {
            this.charset = defaultCharset;
        }
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        if (this.mediaType != null) {
            sbuff.append(this.mediaType);
        }
        if (this.charset != null) {
            sbuff.append("; charset=");
            sbuff.append(this.charset);
        }
        return sbuff.toString();
    }

    private void parse(String s2) {
        if (s2 == null) {
            return;
        }
        this.params = s2.split(";");
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i] = this.params[i].trim();
            if (this.params[i].matches("charset\\s*=.*")) {
                int k = this.params[i].indexOf(61);
                this.charset = this.params[i].substring(k + 1).trim();
                continue;
            }
            this.mediaType = this.params[i];
        }
    }
}

