/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.vocabulary.ResultSetGraphVocab;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;

public class RDFOutput {
    private boolean reportAllVars = false;
    private boolean includeTypeProperties = false;

    public boolean getAllVars() {
        return this.reportAllVars;
    }

    public void setAllVars(boolean all) {
        this.reportAllVars = all;
    }

    public Model toModel(ResultSet resultSet) {
        Model m3 = GraphFactory.makeJenaDefaultModel();
        this.asRDF(m3, resultSet);
        if (m3.getNsPrefixURI("rs") == null) {
            m3.setNsPrefix("rs", ResultSetGraphVocab.getURI());
        }
        if (m3.getNsPrefixURI("rdf") == null) {
            m3.setNsPrefix("rdf", RDF.getURI());
        }
        return m3;
    }

    public Resource asRDF(Model model, ResultSet resultSet) {
        Resource results = model.createResource();
        results.addProperty(RDF.type, ResultSetGraphVocab.ResultSet);
        for (String vName : resultSet.getResultVars()) {
            results.addProperty(ResultSetGraphVocab.resultVariable, vName);
        }
        int count = 0;
        while (resultSet.hasNext()) {
            Iterator<String> iter;
            ++count;
            QuerySolution rBind = resultSet.nextSolution();
            Resource thisSolution = model.createResource();
            if (this.includeTypeProperties) {
                thisSolution.addProperty(RDF.type, ResultSetGraphVocab.ResultSolution);
            }
            results.addProperty(ResultSetGraphVocab.solution, thisSolution);
            Iterator<String> iterator = iter = this.getAllVars() ? rBind.varNames() : resultSet.getResultVars().iterator();
            while (iter.hasNext()) {
                Resource thisBinding = model.createResource();
                String rVar = iter.next();
                RDFNode n = rBind.get(rVar);
                if (n == null) continue;
                if (this.includeTypeProperties) {
                    thisBinding.addProperty(RDF.type, ResultSetGraphVocab.ResultBinding);
                }
                thisBinding.addProperty(ResultSetGraphVocab.variable, rVar);
                thisBinding.addProperty(ResultSetGraphVocab.value, n);
                thisSolution.addProperty(ResultSetGraphVocab.binding, thisBinding);
            }
        }
        results.addProperty(ResultSetGraphVocab.size, model.createTypedLiteral(count));
        this.addPrefixes(model);
        return results;
    }

    public Model toModel(boolean result) {
        Model m3 = GraphFactory.makeJenaDefaultModel();
        this.asRDF(m3, result);
        this.addPrefixes(m3);
        return m3;
    }

    private void addPrefixes(Model model) {
        if (model.getNsPrefixURI("rs") == null) {
            model.setNsPrefix("rs", ResultSetGraphVocab.getURI());
        }
        if (model.getNsPrefixURI("rdf") == null) {
            model.setNsPrefix("rdf", RDF.getURI());
        }
        if (model.getNsPrefixURI("xsd") == null) {
            model.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        }
    }

    public Resource asRDF(Model model, boolean result) {
        Resource results = model.createResource();
        results.addProperty(RDF.type, ResultSetGraphVocab.ResultSet);
        Literal lit = model.createTypedLiteral(result);
        results.addProperty(ResultSetGraphVocab.p_boolean, lit);
        return results;
    }
}

