/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ResourceUtils {
    private static final int WINDOW_SIZE = 1000;

    public static <T extends Resource> List<T> maximalLowerElements(Collection<T> resources, Property rel, boolean inverse) {
        return ResourceUtils.maximalLowerElements(resources.iterator(), rel, inverse);
    }

    public static <T extends Resource> List<T> maximalLowerElements(Iterator<T> resources, Property rel, boolean inverse) {
        ArrayList<T> in = new ArrayList<T>();
        ArrayList out = new ArrayList();
        ArrayList<Resource> drop = new ArrayList<Resource>();
        while (resources.hasNext()) {
            in.add(resources.next());
        }
        while (!in.isEmpty()) {
            Resource r = (Resource)in.remove(0);
            boolean rCovered = ResourceUtils.testResourceCovered(in, rel, inverse, r) || ResourceUtils.testResourceCovered(out, rel, inverse, r) || ResourceUtils.testResourceCovered(drop, rel, inverse, r);
            (rCovered ? drop : out).add(r);
        }
        return out;
    }

    private static boolean testResourceCovered(List<? extends Resource> l, Property rel, boolean inverse, Resource r) {
        boolean rCovered = false;
        Iterator<? extends Resource> i = l.iterator();
        while (!rCovered && i.hasNext()) {
            Resource next = i.next();
            rCovered = inverse ? r.hasProperty(rel, next) : next.hasProperty(rel, r);
        }
        return rCovered;
    }

    public static <T extends Resource> List<T> removeEquiv(List<T> l, Property p, Resource ref) {
        ArrayList<Resource> equiv = new ArrayList<Resource>();
        for (Resource r : l) {
            if (!r.hasProperty(p, ref) || !ref.hasProperty(p, r)) continue;
            equiv.add(r);
        }
        l.removeAll(equiv);
        return equiv;
    }

    public static <T extends Resource> List<List<T>> partition(List<T> l, Property p) {
        ArrayList<T> source = new ArrayList<T>();
        source.addAll(l);
        ArrayList<List<T>> parts = new ArrayList<List<T>>();
        while (!source.isEmpty()) {
            Resource seed = (Resource)source.remove(0);
            List<Resource> part = ResourceUtils.removeEquiv(source, p, seed);
            part.add(seed);
            parts.add(part);
        }
        return parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource renameResource(Resource old, String uri) {
        String oldURI = old.getURI();
        if (oldURI != null && oldURI.equals(uri)) {
            return old;
        }
        Node resAsNode = old.asNode();
        Model model = old.getModel();
        Graph graph = model.getGraph();
        Graph rawGraph = graph instanceof InfGraph ? ((InfGraph)graph).getRawGraph() : graph;
        Resource newRes = model.createResource(uri);
        Node newResAsNode = newRes.asNode();
        boolean changeOccured = false;
        ArrayList triples = new ArrayList(1000);
        boolean onFirstIterator = true;
        try (ExtendedIterator<Triple> it = rawGraph.find(resAsNode, Node.ANY, Node.ANY);){
            if (!it.hasNext()) {
                it.close();
                onFirstIterator = false;
                it = rawGraph.find(Node.ANY, Node.ANY, resAsNode);
            }
            changeOccured = it.hasNext();
            while (it.hasNext()) {
                for (int count = 0; it.hasNext() && count < 1000; ++count) {
                    triples.add(it.next());
                }
                it.close();
                for (Triple t : triples) {
                    rawGraph.delete(t);
                }
                for (Triple t : triples) {
                    Node oldS = t.getSubject();
                    Node oldO = t.getObject();
                    Node newS = oldS.equals(resAsNode) ? newResAsNode : oldS;
                    Node newO = oldO.equals(resAsNode) ? newResAsNode : oldO;
                    rawGraph.add(Triple.create(newS, t.getPredicate(), newO));
                }
                triples.clear();
                ExtendedIterator<Triple> extendedIterator = it = onFirstIterator ? rawGraph.find(resAsNode, Node.ANY, Node.ANY) : rawGraph.find(Node.ANY, Node.ANY, resAsNode);
                if (!onFirstIterator || it.hasNext()) continue;
                it.close();
                onFirstIterator = false;
                it = rawGraph.find(Node.ANY, Node.ANY, resAsNode);
            }
        }
        if (rawGraph != graph && changeOccured) {
            ((InfGraph)graph).rebind();
        }
        return newRes;
    }

    public static Model reachableClosure(Resource root) {
        Model m3 = ModelFactory.createDefaultModel();
        Set seen = CollectionFactory.createHashedSet();
        LinkedList<RDFNode> queue = new LinkedList<RDFNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            Resource r = (Resource)queue.remove(0);
            if (seen.contains(r)) continue;
            seen.add(r);
            StmtIterator i = r.listProperties();
            while (i.hasNext()) {
                Statement s2 = i.nextStatement();
                m3.add(s2);
                if (!(s2.getObject() instanceof Resource)) continue;
                queue.add(s2.getObject());
            }
        }
        return m3;
    }
}

