/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.inventory;

import edu.wisc.library.ocfl.api.OcflOption;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.inventory.InventoryUpdater;
import edu.wisc.library.ocfl.core.util.DigestUtil;
import edu.wisc.library.ocfl.core.util.FileUtil;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddFileProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AddFileProcessor.class);
    private final InventoryUpdater inventoryUpdater;
    private final Path stagingDir;
    private final DigestAlgorithm digestAlgorithm;

    public static Builder builder() {
        return new Builder();
    }

    public AddFileProcessor(InventoryUpdater inventoryUpdater, Path stagingDir, DigestAlgorithm digestAlgorithm) {
        this.inventoryUpdater = Enforce.notNull(inventoryUpdater, "inventoryUpdater cannot be null");
        this.stagingDir = Enforce.notNull(stagingDir, "stagingDir cannot be null");
        this.digestAlgorithm = Enforce.notNull(digestAlgorithm, "digestAlgorithm cannot be null");
    }

    public Map<String, Path> processPath(Path sourcePath, OcflOption ... ocflOptions) {
        return this.processPath(sourcePath, "", ocflOptions);
    }

    public Map<String, Path> processPath(Path sourcePath, String destinationPath, OcflOption ... options) {
        Enforce.notNull(sourcePath, "sourcePath cannot be null");
        Enforce.notNull(destinationPath, "destinationPath cannot be null");
        HashMap<String, Path> results = new HashMap<String, Path>();
        Set<OcflOption> optionsSet = OcflOption.toSet(options);
        String destination = this.destinationPath(destinationPath, sourcePath);
        try (Stream<Path> paths = Files.walk(sourcePath, FileVisitOption.FOLLOW_LINKS);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String logicalPath;
                String digest = DigestUtil.computeDigestHex(this.digestAlgorithm, file);
                InventoryUpdater.AddFileResult result = this.inventoryUpdater.addFile(digest, logicalPath = this.logicalPath(sourcePath, (Path)file, destination), options);
                if (result.isNew()) {
                    results.put(logicalPath, this.stagingFullPath(result.getPathUnderContentDir()));
                    Path stagingFullPath = this.stagingFullPath(result.getPathUnderContentDir());
                    if (optionsSet.contains((Object)OcflOption.MOVE_SOURCE)) {
                        LOG.debug("Moving file <{}> to <{}>", file, (Object)stagingFullPath);
                        FileUtil.moveFileMakeParents(file, stagingFullPath, StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        LOG.debug("Copying file <{}> to <{}>", file, (Object)stagingFullPath);
                        FileUtil.copyFileMakeParents(file, stagingFullPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
            });
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
        if (optionsSet.contains((Object)OcflOption.MOVE_SOURCE)) {
            FileUtil.safeDeleteDirectory(sourcePath);
        }
        return results;
    }

    private String destinationPath(String path, Path sourcePath) {
        if (path.isBlank() && Files.isRegularFile(sourcePath, new LinkOption[0])) {
            return sourcePath.getFileName().toString();
        }
        return path;
    }

    private String logicalPath(Path sourcePath, Path sourceFile, String destinationPath) {
        String sourceRelative = FileUtil.pathToStringStandardSeparator(sourcePath.relativize(sourceFile));
        return FileUtil.pathJoinIgnoreEmpty(destinationPath, sourceRelative);
    }

    private Path stagingFullPath(String pathUnderContentDir) {
        return Paths.get(FileUtil.pathJoinFailEmpty(this.stagingDir.toString(), pathUnderContentDir), new String[0]);
    }

    public static class Builder {
        public AddFileProcessor build(InventoryUpdater inventoryUpdater, Path stagingDir, DigestAlgorithm digestAlgorithm) {
            return new AddFileProcessor(inventoryUpdater, stagingDir, digestAlgorithm);
        }
    }
}

