/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.model.PathBiMap;
import edu.wisc.library.ocfl.core.model.User;
import edu.wisc.library.ocfl.core.model.VersionBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonPropertyOrder(value={"created", "message", "user", "state"})
public class Version {
    private final OffsetDateTime created;
    private final String message;
    private final User user;
    @JsonIgnore
    private final PathBiMap stateBiMap;

    public static VersionBuilder builder() {
        return new VersionBuilder();
    }

    public static VersionBuilder builder(Version original) {
        return new VersionBuilder(original);
    }

    @JsonCreator
    public Version(@JsonProperty(value="created") OffsetDateTime created, @JsonProperty(value="message") String message, @JsonProperty(value="user") User user, @JsonProperty(value="state") Map<String, Set<String>> state) {
        this.created = Enforce.notNull(created, "created cannot be null");
        this.message = message;
        this.user = user;
        this.stateBiMap = PathBiMap.fromFileIdMap(state);
    }

    @JsonGetter(value="created")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @JsonGetter(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonGetter(value="user")
    public User getUser() {
        return this.user;
    }

    @JsonGetter(value="state")
    public Map<String, Set<String>> getState() {
        return this.stateBiMap.getFileIdToPaths();
    }

    public String getFileId(String path) {
        return this.stateBiMap.getFileId(path);
    }

    public Set<String> getPaths(String fileId) {
        return this.stateBiMap.getPaths(fileId);
    }

    public String toString() {
        return "Version{created=" + this.created + ", message='" + this.message + "', user=" + this.user + ", state=" + this.stateBiMap + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version2 = (Version)o;
        return this.created.equals(version2.created) && Objects.equals(this.message, version2.message) && Objects.equals(this.user, version2.user) && this.stateBiMap.equals(version2.stateBiMap);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.message, this.user, this.stateBiMap);
    }
}

